package com.pcloud.book.skill.facade.request;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.rightsSetting.entity.BaseTempletClassify;
import com.pcloud.book.skill.entity.PcloudGroupActivity;
import com.pcloud.common.entity.BaseRequestVO;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 保存共读活动
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("新增共读活动")
public class SaveGroupActivityRequestVO extends BaseTempletClassify {

    private static final long serialVersionUID = -5370056714391879364L;

    @ApiModelProperty("共度名称")
    private String name;

    @ApiModelProperty("描述")
    private String desc;

    @ApiModelProperty("群图片，加群方式为图片时有效")
    private String groupPic;

    @ApiModelProperty("加群类型（0：邀请 1：图片）")
    private Integer joinType;

    @ApiModelProperty("专业标签")
    private Long proLabelId;

    @ApiModelProperty("深度标签")
    private Long depLabelId;

    @ApiModelProperty("目的标签")
    private Long purLabelId;

    @ApiModelProperty("社群码id")
    private Long bookGroupQrcodeId;

    public void checkParam() {
        if (StringUtil.isBlank(this.getName())
                || null == this.getProLabelId() || null == this.getDepLabelId()
                || null == this.getJoinType() || (this.getJoinType() == 1 && StringUtil.isBlank(this.getGroupPic()))
                || null == this.getPurLabelId() || null == this.getBookGroupQrcodeId()) {
            throw new BookBizException(BookBizException.PARAM_IS_NULL, "请求参数缺失");
        }
    }

    /**
     * 转换实体映射
     */
    public PcloudGroupActivity getEntity() {
        PcloudGroupActivity pcloudGroupActivity = new PcloudGroupActivity();
        BeanUtils.copyProperties(this, pcloudGroupActivity);
        return pcloudGroupActivity;
    }

}
