package com.pcloud.book.timecontrol.biz;

import com.pcloud.book.timecontrol.dto.ReplyMessageBaseDto;
import com.pcloud.book.timecontrol.vo.CreatePrize4TaskItemVO;
import com.pcloud.book.timecontrol.vo.QueryPrizeVO;
import com.pcloud.book.timecontrol.vo.SaveTaskPrizeVO;
import com.pcloud.book.timecontrol.vo.request.SavePrize4TaskItemVO;

import java.util.List;

public interface TaskPrizeBiz {

    Integer saveTaskPrize(SaveTaskPrizeVO saveTaskPrizeVO);

    Integer createPrize4TaskItem(CreatePrize4TaskItemVO createPrize4TaskItemVO);

    QueryPrizeVO getPrize4Task(Integer taskId);

    /**
     * 根据taskItem获取单次任务奖励
     * @param taskItemId
     * @return
     */
    QueryPrizeVO getPrize4TaskItem(Integer taskItemId);


    List<ReplyMessageBaseDto> listTaskItemPrize(Integer taskId);

    /**
     * 修改单次任务奖励
     * @param vo
     */
    void savePrize4TaskItem(SavePrize4TaskItemVO vo);

    String downloadCertificate(Integer id, Integer type);
}
