package com.pcloud.book.pcloudKeyword.service;

import com.pcloud.book.pcloudKeyword.dto.PcloudRobotDTO;
import com.pcloud.book.pcloudKeyword.dto.RobotClassifyDTO;
import com.pcloud.common.dto.ResponseDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

@FeignClient(value = "pcloud-service-book", qualifier = "robotServiceCloud", path = "book/v1.0/pcloudRobotService")
@Api(description = "平台个人号内部接口")
public interface PcloudRobotService {

    @ApiOperation(value = "批量获取个人号分类信息", httpMethod = "POST")
    @PostMapping("getRobotClassifyBatch")
    ResponseEntity<ResponseDto<Map<String, RobotClassifyDTO>>> getRobotClassifyBatch(@RequestBody List<String> robotIds);


    @ApiOperation(value = "获取所有个人号分类信息", httpMethod = "GET")
    @GetMapping("getAllPcloudRobot")
    ResponseEntity<ResponseDto<List<RobotClassifyDTO>>> getAllPcloudRobot();

    @ApiOperation(value = "新增个人号信息", httpMethod = "POST")
    @PostMapping("addPcloudRobot")
    void addPcloudRobot(@RequestBody PcloudRobotDTO pcloudRobotDTO);

    @ApiOperation(value = "修改个人号信息", httpMethod = "POST")
    @PostMapping("modifyPcloudRobot")
    void modifyPcloudRobot(@RequestBody PcloudRobotDTO pcloudRobotDTO);

    @ApiOperation("根据小号类别获取小号")
    @GetMapping("getPcloudRobotByType")
    public ResponseEntity<ResponseDto<List<String>>> getPcloudRobotByType(@RequestParam("robotType") @ApiParam("小号分类") Long robotType);

    @ApiOperation("根据小号id列表获取小号信息")
    @PostMapping("getPcloudRobotByRobotIds")
    public ResponseEntity<ResponseDto<Map<String,PcloudRobotDTO>>> getPcloudRobotByRobotIds(@RequestBody List<String> robotIds);

    @ApiOperation("表单提交后进行用户阶段跳转")
    @GetMapping("changePersonalStage")
    void changePersonalStage(@RequestParam("robotId") String robotId, @RequestParam("wxUserId") String wxUserId, @RequestParam("paperId") Long paperId);
}
