package com.pcloud.book.group.dao.impl;

import com.pcloud.book.group.dao.BookGroupServeDao;
import com.pcloud.book.group.dto.BookGroupCountDTO;
import com.pcloud.book.group.entity.BookGroupApp;
import com.pcloud.book.group.entity.BookGroupServe;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/9/23 15:39
 **/
@Component("bookGroupServeDao")
public class BookGroupServeDaoImpl extends BaseDaoImpl<BookGroupServe> implements BookGroupServeDao {
    @Override
    public Integer batchInsert(List<BookGroupServe> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public List<BookGroupServe> getListByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return super.getSqlSession().selectList(getStatement("getListByBookGroupId"), map);
    }

    @Override
    public void deleteByBookGroupId(Long bookGroupId) {
        super.getSqlSession().delete(getStatement("deleteByBookGroupId"), bookGroupId);
    }

    @Override
    public List<BookGroupServe> getListByServerType(String serveType) {
        return super.getSqlSession().selectList(getStatement("getListByServerType"), serveType);
    }

    @Override
    public void updateShortUrl(Long id, String shortUrl) {
        Map<String, Object> map = new HashMap<>();
        map.put("id", id);
        map.put("shortUrl", shortUrl);
        super.getSqlSession().update(getStatement("updateShortUrl"), map);
    }

    @Override
    public List<BookGroupServe> getProductServeList() {
        return super.getSqlSession().selectList(getStatement("getProductServeList"));
    }

    @Override
    public List<BookGroupApp> getAllAppServe() {
        return super.getSqlSession().selectList(getStatement("getAllAppServe"));
    }

    @Override
    public Integer getCountByBookGroupId(Long bookGroupId) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupId", bookGroupId);
        return super.getSqlSession().selectOne(getStatement("getCountByBookGroupId"), map);
    }

    @Override
    public List<BookGroupServe> getListByBookGroupIds(List<Long> bookGroupIds) {
        return super.getSqlSession().selectList(getStatement("getListByBookGroupIds"), bookGroupIds);
    }

    @Override
    public void deleteByBookGroupIds(List<Long> bookGroupIds) {
        Map<String, Object> map = new HashMap<>();
        map.put("bookGroupIds", bookGroupIds);
        super.getSqlSession().delete(getStatement("deleteByBookGroupIds"), map);
    }

    @Override
    public List<BookGroupCountDTO> getCountByServeIds(List<Long> serveIds, String serveType, Long adviserId) {
        Map<String, Object> map = new HashMap<>();
        map.put("serveIds", serveIds);
        map.put("serveType", serveType);
        map.put("adviserId", adviserId);
        return super.getSqlSession().selectList(getStatement("getCountByServeIds"), map);
    }
}
