package com.pcloud.book.personalstage.biz;

import com.pcloud.book.personalstage.dto.PersonalStageJumpDto;
import com.pcloud.book.personalstage.enums.JumpTypeEnum;
import com.pcloud.book.personalstage.vo.request.CreateStageJumpRequestVO;
import com.pcloud.book.personalstage.vo.request.UpdateStageJumpRequestVO;
import com.pcloud.common.core.mq.DelayQueueDTO;
import com.pcloud.common.page.PageBeanNew;

public interface PersonalStageJumpBiz {
    /**
     * 新建阶段跳转
     * @param vo
     */
    void createPersonalStageJump(CreateStageJumpRequestVO vo);

    /**
     * 修改阶段跳转
     * @param vo
     */
    void updatePersonalStageJump(UpdateStageJumpRequestVO vo);

    PageBeanNew getJumpList(Long personalStageId, Integer currentPage, Integer numPerPage);

    PersonalStageJumpDto getJump(Long jumpId);

    void deleteJump(Long jumpId);

    Long updateEmailStatus(Long jumpId, Integer openEmail);

    /**
     * 处理用户跳转逻辑
     * 用户的消息状态
     * @return  false:未能跳转到下个阶段，需要后续的其它处理；
     *          true:命中关键字，已经跳转到下个阶段，无需后续处理；
     */
    Boolean handlePersonalStageJump(String userWxId, String robotWxId, String content, JumpTypeEnum jumpTypeEnum);

    void dealDelayLinkup(DelayQueueDTO dto);

    /**
     * 处理用户提交表单阶段跳转
     * @param userWxId
     * @param robotWxId
     * @param paperId
     * @return
     */
    boolean handlePersonalStagePaperJump(String userWxId, String robotWxId, Long paperId);

    void sendPaperEmail(String userWxId, String robotWxId);
}
