package com.pcloud.book.personalstage.check;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.keywords.enums.ReplyTypeEnum;
import com.pcloud.book.personalstage.entity.PersonalStage;
import com.pcloud.book.personalstage.entity.PersonalStageReply;
import com.pcloud.book.personalstage.entity.PersonalStageReplyItem;
import com.pcloud.book.personalstage.entity.PersonalStageWakeup;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.stereotype.Component;

import java.util.List;

@Component("定制化参数校验")
public class PersonalStageCheck {

    @ParamLog("新增定制化阶段参数校验")
    public void createPersonalStageParamCheck(PersonalStage personalStage) {
        if (personalStage==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"定制化阶段不能为空！");
        }
        if (personalStage.getRobotClassifyId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"关键词分类不能为空！");
        }
        if (StringUtil.isEmpty(personalStage.getName())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"阶段名称不能为空！");
        }
        if (personalStage.getNotKeywordFusingCount()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"发送阶段非关键词回复语次数不能为空！");
        }
        if (personalStage.getNotKeywordFusingTime()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"触发熔断后几分钟恢复正常不能为空！");
        }
        if (ListUtils.isEmpty(personalStage.getStageNotKeywordReplies())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"阶段非关键词回复集合不能为空！");
        }
        //获取需求定制单id
        Long paperId = checkReplies(personalStage.getStageNotKeywordReplies());
        personalStage.setPaperId(paperId);
        if (ListUtils.isEmpty(personalStage.getFusingNotKeywordReplies())){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"熔断非关键词恢复集合不能为空！");
        }
        checkReplies(personalStage.getFusingNotKeywordReplies());
        if (!ListUtils.isEmpty(personalStage.getPersonalStageWakeups())){
            checkWakeups(personalStage.getPersonalStageWakeups());
        }
    }

    @ParamLog("校验唤醒")
    private void checkWakeups(List<PersonalStageWakeup> list) {
        for (PersonalStageWakeup wakeup:list){
            if (wakeup==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"唤醒不能为空！");
            }
            if (wakeup.getToStageStartTime()==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"距离进入阶段时间不能为空！");
            }
            if (ListUtils.isEmpty(wakeup.getWakeupReplies())){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"唤醒回复集合不能为空！");
            }
            checkReplies(wakeup.getWakeupReplies());
        }
    }

    @ParamLog("校验回复")
    private Long checkReplies(List<PersonalStageReply> list) {
        Long paperId = null;
        for (PersonalStageReply reply:list){
            if (reply==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复不能为空！");
            }
            if (ListUtils.isEmpty(reply.getPersonalStageReplyItems())){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复项集合不能为空！");
            }
            if (null != reply.getPaperId()){
                if (null != paperId){
                    if (!reply.getPaperId().equals(paperId)){
                        throw new BookBizException(BookBizException.PARAM_IS_ERROR, "非关键词回复存在不一样的需求定制单");
                    }
                }else{
                    paperId = reply.getPaperId();
                }
            }
            checkReplayItems(reply.getPersonalStageReplyItems());
        }
        return paperId;
    }

    @ParamLog("校验回复项")
    private void checkReplayItems(List<PersonalStageReplyItem> list) {
        for (PersonalStageReplyItem item:list){
            if (item==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复项不能为空！");
            }
            if (item.getReplyType()==null){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复项类型不能为空！");
            }
            if (ReplyTypeEnum.TEXT.value.equals(item.getReplyType())&&StringUtil.isEmpty(item.getContent())){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复项内容不能为空！");
            }
            if (ReplyTypeEnum.IMAGE.value.equals(item.getReplyType())&&StringUtil.isEmpty(item.getPicUrl())){
                throw new BookBizException(BookBizException.PARAM_IS_ERROR,"回复项图片不能为空！");
            }
        }
    }

    @ParamLog("修改定制化阶段参数校验")
    public void updatePersonalStageParamCheck(PersonalStage personalStage) {
        if (personalStage==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"定制化阶段不能为空！");
        }
        if (personalStage.getId()==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"定制化阶段id不能为空！");
        }
        createPersonalStageParamCheck(personalStage);
    }
}
