package com.pcloud.book.personalstage.dao;

import com.pcloud.book.personalstage.entity.PersonalStageJumpLinkup;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

public interface PersonalStageJumpLinkupDao extends BaseDao<PersonalStageJumpLinkup> {
    /**
     * 批量新增
     * @param personalStageJumpLinkups
     */
    void batchInsert(List<PersonalStageJumpLinkup> personalStageJumpLinkups);

    /**
     * 根据阶段跳转id删除
     * @param personalStageJumpId
     */
    void deleteByJumpId(Long personalStageJumpId);

    /**
     * 根据跳转id查询衔接语列表
     * @param jumpId
     * @return
     */
    List<PersonalStageJumpLinkup> getByJumpId(Long jumpId);
}