package com.pcloud.book.personalstage.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;
import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;


@ApiModel("定制化阶段")
@Data
public class PersonalStageDTO extends BaseDto {

    private static final long serialVersionUID = -5560187538777872008L;

    @ApiModelProperty("阶段id")
    private Long id;

    @ApiModelProperty("阶段名称")
    private String name;

    @ApiModelProperty("发送阶段非关键词回复语次数")
    private Integer notKeywordFusingCount;

    @ApiModelProperty("触发熔断后几分钟恢复正常")
    private Long notKeywordFusingTime;

    @ApiModelProperty("机器人分类id")
    private Long robotClassifyId;

    @ApiModelProperty("需求定制单id")
    private Long paperId;

    @ApiModelProperty("排序值")
    private Integer seqNum;

    @ApiModelProperty("显示进度链接")
    private Integer showProgress;

    @ApiModelProperty("非关键词回复条数")
    private Integer notKeywordReplyCount;

    @ApiModelProperty("非关键词熔断回复条数")
    private Integer notKeywordFusingReplyCount;

    @ApiModelProperty("创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

}