package com.pcloud.book.advertising.dao.impl;

import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingSpaceDao;
import com.pcloud.book.advertising.dto.AdvertisingSpaceDTO;
import com.pcloud.book.advertising.entity.AdvertisingSpace;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingSpaceDao")
public class AdvertisingSpaceDaoImpl extends BaseDaoImpl<AdvertisingSpace> implements AdvertisingSpaceDao {

    /**
     * 获取广告位信息
     */
    @Override
    public AdvertisingSpaceDTO getDTOById(Long adId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), adId);
    }

    /**
     * 书刊广告位明细
     */
    @Override
    public List<AdvertisingSpaceDTO> advertisingDetail4Book(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("advertisingDetail4Book"), paramMap);
    }

    /**
     * 微信群广告位明细
     */
    @Override
    public List<AdvertisingSpaceDTO> advertisingDetail4WechatGroup(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("advertisingDetail4WechatGroup"), paramMap);
    }

    /**
     * 广告主广告位明细
     */
    @Override
    public List<AdvertisingSpaceDTO> advertisingDetail4Master(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("advertisingDetail4Master"), paramMap);
    }

    /**
     * 获取书刊下的广告位列表
     */
    @Override
    public List<AdvertisingSpaceDTO> getDTOByBookId(Map<String, Object> paramMap) {
        return super.getSqlSession().selectList(getStatement("getDTOByBookId"), paramMap);
    }
}
