package com.pcloud.book.advertising.dto;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

/**
 * @author PENG
 */
public class AdvertisingSpaceDTO extends BaseDto {

    private static final long serialVersionUID = -1774181367397964304L;

    /**
     * advertising_space.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_space.ad_name (广告位名称)
     */
    private String adName;

    /**
     * advertising_space.ad_position (广告位置)
     */
    private String adPosition;

    /**
     * advertising_space.ad_position_mode (广告位置方式)
     */
    private String adPositionMode;

    /**
     * advertising_space.ad_position_detail (具体广告位置)
     */
    private String adPositionDetail;

    /**
     * 广告位置名称
     */
    private String adPositionName;

    /**
     * advertising_space.master_id (广告主ID)
     */
    private Long masterId;

    /**
     * 广告主名称
     */
    private String masterName;

    /**
     * advertising_space.ad_link (广告位链接)
     */
    private String adLink;

    /**
     * advertising_space.source_id (对方id)
     */
    private String sourceId;

    /**
     * advertising_space.ad_title (广告位标题)
     */
    private String adTitle;

    /**
     * advertising_space.ad_slogan (广告位文案)
     */
    private String adSlogan;

    /**
     * advertising_space.ad_pic (广告位图片)
     */
    private String adPic;

    /**
     * advertising_space.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * advertising_space.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * advertising_space.is_open (是否打开)
     */
    private Boolean isOpen;

    /**
     * 投放书刊数量
     */
    private Integer bookNum;

    /**
     * 投放书刊名称
     */
    private String bookName;

    /**
     * 书刊ID
     */
    private Long bookId;

    /**
     * 曝光量
     */
    private Long exposureNum;

    /**
     * 点击量
     */
    private Long clickNum;

    /**
     * 点击读者量
     */
    private Long clickUserNum;

    /**
     * 点击率
     */
    private BigDecimal clickRate;

    /**
     * 累积消费
     */
    private BigDecimal totalIncome;

    /**
     * 结算方式
     */
    private String settlementMethod;

    /**
     * 结算方式名称
     */
    private String settlementMethodName;

    /**
     * 每次价格
     */
    private BigDecimal priceEachTime;

    /**
     * 投放时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date distributionTime;

    /**
     * 微信群ID
     */
    private Long qrcodeId;

    /**
     * 微信群名称
     */
    private String groupQrcodeName;

    /**
     * 书号
     */
    private String isbn;

    /**
     * 出版社ID
     */
    private Long agentId;

    /**
     * 出版社名称
     */
    private String agentName;

    /**
     * 编辑ID
     */
    private Long adviserId;

    /**
     * 运营ID
     */
    private Long channelId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getAdPosition() {
        return adPosition;
    }

    public void setAdPosition(String adPosition) {
        this.adPosition = adPosition;
    }

    public String getAdLink() {
        return adLink;
    }

    public void setAdLink(String adLink) {
        this.adLink = adLink;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getAdSlogan() {
        return adSlogan;
    }

    public void setAdSlogan(String adSlogan) {
        this.adSlogan = adSlogan;
    }

    public String getAdPic() {
        return adPic;
    }

    public void setAdPic(String adPic) {
        this.adPic = adPic;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Integer getBookNum() {
        return bookNum;
    }

    public void setBookNum(Integer bookNum) {
        this.bookNum = bookNum;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public String getAdPositionMode() {
        return adPositionMode;
    }

    public void setAdPositionMode(String adPositionMode) {
        this.adPositionMode = adPositionMode;
    }

    public String getAdPositionDetail() {
        return adPositionDetail;
    }

    public void setAdPositionDetail(String adPositionDetail) {
        this.adPositionDetail = adPositionDetail;
    }

    public Long getMasterId() {
        return masterId;
    }

    public void setMasterId(Long masterId) {
        this.masterId = masterId;
    }

    public String getAdTitle() {
        return adTitle;
    }

    public void setAdTitle(String adTitle) {
        this.adTitle = adTitle;
    }

    public String getMasterName() {
        return masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public BigDecimal getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public String getSettlementMethod() {
        return settlementMethod;
    }

    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    public String getSettlementMethodName() {
        return settlementMethodName;
    }

    public void setSettlementMethodName(String settlementMethodName) {
        this.settlementMethodName = settlementMethodName;
    }

    public BigDecimal getPriceEachTime() {
        return priceEachTime;
    }

    public void setPriceEachTime(BigDecimal priceEachTime) {
        this.priceEachTime = priceEachTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getDistributionTime() {
        return distributionTime;
    }

    public void setDistributionTime(Date distributionTime) {
        this.distributionTime = distributionTime;
    }

    public String getAdPositionName() {
        return adPositionName;
    }

    public void setAdPositionName(String adPositionName) {
        this.adPositionName = adPositionName;
    }

    public Long getQrcodeId() {
        return qrcodeId;
    }

    public void setQrcodeId(Long qrcodeId) {
        this.qrcodeId = qrcodeId;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    public Long getAgentId() {
        return agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getAdviserId() {
        return adviserId;
    }

    public void setAdviserId(Long adviserId) {
        this.adviserId = adviserId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public Long getClickUserNum() {
        return clickUserNum;
    }

    public void setClickUserNum(Long clickUserNum) {
        this.clickUserNum = clickUserNum;
    }

    @Override
    public String toString() {
        return "AdvertisingSpaceDTO{" +
                "id=" + id +
                ", adName='" + adName + '\'' +
                ", adPosition='" + adPosition + '\'' +
                ", adPositionMode='" + adPositionMode + '\'' +
                ", adPositionDetail='" + adPositionDetail + '\'' +
                ", adPositionName='" + adPositionName + '\'' +
                ", masterId=" + masterId +
                ", masterName='" + masterName + '\'' +
                ", adLink='" + adLink + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", adTitle='" + adTitle + '\'' +
                ", adSlogan='" + adSlogan + '\'' +
                ", adPic='" + adPic + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isOpen=" + isOpen +
                ", bookNum=" + bookNum +
                ", bookName='" + bookName + '\'' +
                ", bookId=" + bookId +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", clickUserNum=" + clickUserNum +
                ", clickRate=" + clickRate +
                ", totalIncome=" + totalIncome +
                ", settlementMethod='" + settlementMethod + '\'' +
                ", settlementMethodName='" + settlementMethodName + '\'' +
                ", priceEachTime=" + priceEachTime +
                ", distributionTime=" + distributionTime +
                ", qrcodeId=" + qrcodeId +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", isbn='" + isbn + '\'' +
                ", agentId=" + agentId +
                ", agentName='" + agentName + '\'' +
                ", adviserId=" + adviserId +
                ", channelId=" + channelId +
                "} " + super.toString();
    }
}