package com.pcloud.book.consumer.trade;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.facade.tradecenter.dto.QrGroupBuyDetailDto;
import com.pcloud.facade.tradecenter.service.OrderFormService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @Author:lili
 * @Desr:交易调用
 * @Date:2019/5/7 17:22
 */
@Component("tradeConsr")
public class TradeConsr {

    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(TradeConsr.class);
    @Autowired
    private OrderFormService orderFormService;

    public Map<Long, QrGroupBuyDetailDto> getQrGroupSaleDetail(List<Long> qrcodeIds) throws BizException {
        if (ListUtils.isEmpty(qrcodeIds)) {
            return null;
        }
        try {
            return ResponseHandleUtil.parseMapResponse(orderFormService.getQrGroupSaleDetail(qrcodeIds)
                    , Long.class, QrGroupBuyDetailDto.class);
        } catch (Exception e) {
            LOGGER.error("获取购买次数.[getQrGroupSaleDetail]:" + e.getMessage(), e);
        }
        return null;
    }
}
