package com.pcloud.book.group.dao;

import java.util.List;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.common.core.dao.BaseDao;

/**
 * Description 社群书群二维码数据访问层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupDao extends BaseDao<BookGroup> {

    /**
     * 获取DTO信息
     * @param bookGroupId 群二维码ID
     * @return
     */
    BookGroupDTO getDTOById(Long bookGroupId);

    /**
     * 批量获取DTO信息
     * @param bookGroupIds 群二维码ID列表
     * @return
     */
    List<BookGroupDTO> getDTOByIds(List<Long> bookGroupIds);

    /**
     * 获取DTO信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long deleteByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     */
    long recoverByBookId(Long bookId, Long channelId, Long adviserId);

    /**
     * 关联社群码和社群书
     * @param bookGroup 社群码实体
     * @return
     */
    long linkBookGroup(BookGroup bookGroup);

    /**
     * 获取编辑社群书数量
     * @param adviserId 编辑ID
     * @return
     */
    Integer getBookGroupCount(Long adviserId);

    /**
     * @Author:lili
     * @Desr:获取群二维码名称与商品标识
     * @Date:2019/4/18 9:58
     */
    QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取排序类型
     * @Date:2019/4/19 15:01
     */
    Integer getRankType(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:更新排序类型
     * @Date:2019/4/19 15:01
     */
    void updateRankType(Long bookGroupId, Integer rankType);

    /**
     * @Author:lili
     * @Desr:获取备用二维码
     * @Date:2019/5/13 15:10
     */
    String getSpareQr(Long bookGroupId);

    /**
     * 获取社群书基本信息(包括书籍封面isbn号)
     * @param bookGroupIds
     * @return
     */
    List<BookGroupDTO> getBookBaseInfoByIds(List<Long> bookGroupIds);


    /**
     * @Author:lili
     * @Desr:根据二维码获取社群码基本信息
     * @Date:2019/5/27 18:00
     */
    BookGroupDTO getBaseInfoBySceneId(Long sceneId);

    /**
     * @Author:lili
     * @Desr:是否是特殊的出版社
     * @Date:2019/5/28 11:15
     */
    Boolean isSpecialAgent(Long agentId);
}
