package com.pcloud.book.group.dto;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.book.book.dto.BookDto;
import com.pcloud.common.dto.BaseDto;

/**
 * 社群书群二维码DTO
 * @author PENG
 * @date 2019年4月17日11:31:16
 */
public class BookGroupDTO extends BaseDto {

    private static final long serialVersionUID = 7620868422261683212L;

    /**
     * book_group.id (唯一标识)
     */
    private Long id;

    /**
     * book_group.book_id (书刊ID)
     */
    private Long bookId;

    /**
     * book_group.channel_id (运营ID)
     */
    private Long channelId;

    /**
     * book_group.group_qrcode_url (群二维码图片)
     */
    private String groupQrcodeUrl;

    /**
     * book_group.group_qrcode_name (群二维码名称)
     */
    private String groupQrcodeName;

    /**
     * book_group.pro_label_id (专业标签ID)
     */
    private Long proLabelId;

    /**
     * 专业标签名称
     */
    private String proLabelName;

    /**
     * book_group.dep_label_id (深度标签ID)
     */
    private Long depLabelId;

    /**
     * 深度标签名称
     */
    private String depLabelName;

    /**
     * book_group.pur_label_id (目的标签ID)
     */
    private Long purLabelId;

    /**
     * 目的标签名称
     */
    private String purLabelName;

    /**
     * 选择群页面标题
     */
    private String joinTitle;

    /**
     * book_group.join_slogan (进群宣传语)
     */
    private String joinSlogan;

    /**
     * book_group.personal_qrcode_url (个人二维码)
     */
    private String personalQrcodeUrl;

    /**
     * book_group.product_id (商品ID)
     */
    private Long productId;

    /**
     * book_group.create_user (创建人)
     */
    private Long createUser;

    /**
     * book_group.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * book_group.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * book_group.is_delete (是否删除)
     */
    private Boolean isDelete;

    /**
     * 书刊信息
     */
    private BookDto bookInfo;

    /**
     * 书刊封面
     */
    private String bookImg;

    /**
     * isbn号
     */
    private String isbn;

    private String url;

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    public String getGroupQrcodeUrl() {
        return groupQrcodeUrl;
    }

    public void setGroupQrcodeUrl(String groupQrcodeUrl) {
        this.groupQrcodeUrl = groupQrcodeUrl;
    }

    public String getGroupQrcodeName() {
        return groupQrcodeName;
    }

    public void setGroupQrcodeName(String groupQrcodeName) {
        this.groupQrcodeName = groupQrcodeName;
    }

    public Long getProLabelId() {
        return proLabelId;
    }

    public void setProLabelId(Long proLabelId) {
        this.proLabelId = proLabelId;
    }

    public Long getDepLabelId() {
        return depLabelId;
    }

    public void setDepLabelId(Long depLabelId) {
        this.depLabelId = depLabelId;
    }

    public Long getPurLabelId() {
        return purLabelId;
    }

    public void setPurLabelId(Long purLabelId) {
        this.purLabelId = purLabelId;
    }

    public String getJoinTitle() {
        return joinTitle;
    }

    public void setJoinTitle(String joinTitle) {
        this.joinTitle = joinTitle;
    }

    public String getJoinSlogan() {
        return joinSlogan;
    }

    public void setJoinSlogan(String joinSlogan) {
        this.joinSlogan = joinSlogan;
    }

    public String getPersonalQrcodeUrl() {
        return personalQrcodeUrl;
    }

    public void setPersonalQrcodeUrl(String personalQrcodeUrl) {
        this.personalQrcodeUrl = personalQrcodeUrl;
    }

    public Long getProductId() {
        return productId;
    }

    public void setProductId(Long productId) {
        this.productId = productId;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public String getProLabelName() {
        return proLabelName;
    }

    public void setProLabelName(String proLabelName) {
        this.proLabelName = proLabelName;
    }

    public String getDepLabelName() {
        return depLabelName;
    }

    public void setDepLabelName(String depLabelName) {
        this.depLabelName = depLabelName;
    }

    public String getPurLabelName() {
        return purLabelName;
    }

    public void setPurLabelName(String purLabelName) {
        this.purLabelName = purLabelName;
    }

    public BookDto getBookInfo() {
        return bookInfo;
    }

    public void setBookInfo(BookDto bookInfo) {
        this.bookInfo = bookInfo;
    }

    public String getBookImg() {
        return bookImg;
    }

    public void setBookImg(String bookImg) {
        this.bookImg = bookImg;
    }

    public String getIsbn() {
        return isbn;
    }

    public void setIsbn(String isbn) {
        this.isbn = isbn;
    }

    @Override
    public String toString() {
        return "BookGroupDTO{" +
                "id=" + id +
                ", bookId=" + bookId +
                ", channelId=" + channelId +
                ", groupQrcodeUrl='" + groupQrcodeUrl + '\'' +
                ", groupQrcodeName='" + groupQrcodeName + '\'' +
                ", proLabelId=" + proLabelId +
                ", proLabelName='" + proLabelName + '\'' +
                ", depLabelId=" + depLabelId +
                ", depLabelName='" + depLabelName + '\'' +
                ", purLabelId=" + purLabelId +
                ", purLabelName='" + purLabelName + '\'' +
                ", joinTitle='" + joinTitle + '\'' +
                ", joinSlogan='" + joinSlogan + '\'' +
                ", personalQrcodeUrl='" + personalQrcodeUrl + '\'' +
                ", productId=" + productId +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isDelete=" + isDelete +
                ", bookInfo=" + bookInfo +
                ", bookImg='" + bookImg + '\'' +
                ", isbn='" + isbn + '\'' +
                '}';
    }
}