package com.pcloud.book.mq.topic;

import com.pcloud.book.consumer.wechatgroup.WechatGroupConsr;
import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.mq.config.MQTopicConumer;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.wechatgroup.message.dto.GroupNameDTO;
import com.sdk.wxgroup.ChangeNameVO;
import com.sdk.wxgroup.SendTextMessageVO;
import com.sdk.wxgroup.WxGroupSDK;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@RabbitListener(queues = MQTopicConumer.UPDATE_WXGROUP_NAME)
public class UpdateWXGroupNameListener {

    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateWXGroupNameListener.class);

    @Autowired
    private GroupQrcodeDao groupQrcodeDao;
    @Autowired
    private WechatGroupConsr wechatGroupConsr;

    @ParamLog("接收修改群名称topic")
    @RabbitHandler
    public void onMessage(GroupNameDTO groupNameDTO) throws BizException {
        try {
            String wechatGroupId = groupNameDTO.getWechatGroupId();
            if (groupNameDTO == null || wechatGroupId == null
                    || groupNameDTO.getNewGroupName() == null || groupNameDTO.getNickName() == null)
                return;
            GroupQrcode groupQrcode = groupQrcodeDao.getGroupQrcodeByGroupId(wechatGroupId);
            if (groupQrcode == null) {
                LOGGER.info("没有找到该群" + wechatGroupId);
                return;
            }
            if (!groupNameDTO.getNewGroupName().equals(groupQrcode.getGroupName())) {
                ChangeNameVO changeNameVO = new ChangeNameVO();
                changeNameVO.setName(groupQrcode.getGroupName());
                changeNameVO.setWxGroupId(wechatGroupId);
                String altId = wechatGroupConsr.getRobotIdByGroupId(wechatGroupId);
                changeNameVO.setAltId(altId);
                WxGroupSDK.changeGroupName(changeNameVO);
                SendTextMessageVO sendTextMessageVO = new SendTextMessageVO();
                sendTextMessageVO.setContent("@"+groupNameDTO.getNickName()+"，为方便群友入群分享好的助学方法，请不要随意修改群名。如再修改，会将您移出群聊。谢谢配合。");
                sendTextMessageVO.setAltId(altId);
                sendTextMessageVO.setGroupId(wechatGroupId);
                WxGroupSDK.sendTextMessage(sendTextMessageVO);
            }
        } catch (Exception e) {
            LOGGER.error("接收修改群名称失败" + e.getMessage(), e);
        }
    }
}
