package com.pcloud.book.push.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.book.push.entity.PushItem;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/22 10:34
 **/
@JsonInclude(JsonInclude.Include.NON_NULL)
public class PushDTO implements Serializable {
    private static final long serialVersionUID = -4866107113280536409L;

    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("发送类型（1:立即发送 2:单次发送 3:每天发送）")
    private Integer pushType;

    @ApiModelProperty("发送时间")
    private String pushTime;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("更新人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    @ApiModelProperty("推送群集合")
    private List<PushGroup> pushGroups;

    @ApiModelProperty("推送消息项集合")
    private List<PushItem> pushItems;

    @ApiModelProperty("涉及书数量")
    private Integer bookCount;

    @ApiModelProperty("涉及群数量")
    private Integer groupCount;

    @ApiModelProperty("群发项数量")
    private Integer itemCount;

    @ApiModelProperty("群发类型集合")
    private List<String> itemTypes;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public String getPushTime() {
        return pushTime;
    }

    public void setPushTime(String pushTime) {
        this.pushTime = pushTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<PushGroup> getPushGroups() {
        return pushGroups;
    }

    public void setPushGroups(List<PushGroup> pushGroups) {
        this.pushGroups = pushGroups;
    }

    public List<PushItem> getPushItems() {
        return pushItems;
    }

    public void setPushItems(List<PushItem> pushItems) {
        this.pushItems = pushItems;
    }

    public Integer getBookCount() {
        return bookCount;
    }

    public void setBookCount(Integer bookCount) {
        this.bookCount = bookCount;
    }

    public Integer getGroupCount() {
        return groupCount;
    }

    public void setGroupCount(Integer groupCount) {
        this.groupCount = groupCount;
    }

    public Integer getItemCount() {
        return itemCount;
    }

    public void setItemCount(Integer itemCount) {
        this.itemCount = itemCount;
    }

    public List<String> getItemTypes() {
        return itemTypes;
    }

    public void setItemTypes(List<String> itemTypes) {
        this.itemTypes = itemTypes;
    }

    @Override
    public String toString() {
        return "PushDTO{" +
                "id=" + id +
                ", pushType=" + pushType +
                ", pushTime='" + pushTime + '\'' +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", createTime=" + createTime +
                ", updateUser=" + updateUser +
                ", updateTime=" + updateTime +
                ", pushGroups=" + pushGroups +
                ", pushItems=" + pushItems +
                ", bookCount=" + bookCount +
                ", groupCount=" + groupCount +
                ", itemCount=" + itemCount +
                ", itemTypes=" + itemTypes +
                '}';
    }
}
