package com.pcloud.book.advertising.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import lombok.Data;

/**
 *链接转换记录
 */
@Data
public class AdvertisingLinkRevert extends BaseEntity {

    /**
     *品牌方id
     */
    private Long brandId;
    /**
     *原链接
     */
    private String link;
    /**
     * 要转换的链接
     */
    private String revertLink;
    /**
     *短链接
     */
    private String shortLink;
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date createTime;

    private Long createUser;

    /**
     * 发送次数变化
     */
    private Integer sendCountChange;
    /**
     *点击次数变化
     */
    private Integer clickCountChange;
    /**
     *点击人数变化
     */
    private Integer clickUserCountChange;
}