package com.pcloud.book.applet.biz;

import com.pcloud.book.applet.dto.BuyBookRequestDTO;
import com.pcloud.book.applet.dto.BuyBookRequetUserDTO;
import com.pcloud.book.applet.entity.BuyBookRequest;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;

/**
 * (BuyBookRequest)表服务接口
 *
 * @author makejava
 * @since 2020-10-14 19:51:41
 */
public interface BuyBookRequestBiz {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BuyBookRequestDTO getById(Long id);

    /**
     * 分页查询
     */
    PageBeanNew getList(Integer currentPage, Integer numPerPage, Long agentId);

    /**
     * 新增数据
     *
     * @param buyBookRequest 实例对象
     * @return 主键
     */
    Long insert(BuyBookRequest buyBookRequest,Long officialAccountId);

    /**
     * 修改数据
     *
     * @param buyBookRequest 实例对象
     */
    void update(BuyBookRequest buyBookRequest);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

    /**
     * 获取用户数量
     * @return
     * @param topCount
     */
    BuyBookRequetUserDTO getUserCount(Integer topCount);

    /**
     * 导出购书申请
     * @param agentId
     * @param currentPage
     * @param numPerPage
     * @param partyId
     */
    void exportRequestList(Long agentId, Integer currentPage, Integer numPerPage, Long partyId);

    /**
     * 查询用户不同状态记录
     * @param wechatUserId
     * @param state
     * @return
     */
    PageBeanNew getByState(Integer currentPage,Integer numPerPage,Long wechatUserId,Integer state,Integer requestEvn);

    /**
     * 假删除数据
     * @param requestId
     */
    void fakeDelete(Long requestId);

    /**
     * 根据微信UserId获取记录id列表
     * @param wechatUserId
     * @return
     */
    List<Long> listIdsByWeChatUserId(Long wechatUserId);

    /**
     * 获取所有的用户wechatId
     * @return
     */
    List<Long> listAllWeChatUserId();

    /**
     * 处理数据：根据wechatId填充mini_wechat_user_id，wechat_nick_name，mini_open_id
     *           reply_state，is_delete
     */
    void processingData(Integer open);
}