package com.pcloud.book.reading.dao;

import com.pcloud.book.reading.dto.ActivityUserBookDTO;
import com.pcloud.book.reading.dto.ActivityUserCountDTO;
import com.pcloud.book.reading.entity.ReadingUser;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @描述：共读活动邀请用户
 * @作者：zhuyajie
 * @创建时间：17:31 2020/1/14
 * @版本：1.0
 */
public interface ReadingUserDao extends BaseDao<ReadingUser> {

    /**
     * 根据活动id查询
     * @param activityId
     * @return
     */
    List<ReadingUser> getByActivityId(Long activityId, Integer joinState);

    /**
     * 修改用户参加状态
     * @param joinState
     * @param wxUserId
     * @param activityId
     */
    public void updateJoinState(Integer joinState, String wxUserId, String activityId);

    /**
     * 查询活动人数列表
     */
    List<ActivityUserCountDTO> getUserCountsByActivityIds(List<Long> activityIds);

    /**
     * 查用户id
     * @param activityIds
     * @return
     */
    List<String> getWxUserIdByActivityIds(List<Long> activityIds);

    /**
     * 批量获取活动读者书籍
     */
    List<ActivityUserBookDTO> getBooksByActivityIds(List<Long> activityIds);
}
