package com.pcloud.book.advertising.dao.impl;

import java.util.List;
import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingExposureRecordDao;
import com.pcloud.book.advertising.entity.AdvertisingExposureRecord;
import com.pcloud.book.group.dto.AdGroupQrcodeDTO;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位曝光记录数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingExposureRecordDao")
public class AdvertisingExposureRecordDaoImpl extends BaseDaoImpl<AdvertisingExposureRecord> implements AdvertisingExposureRecordDao {

    /**
     * 获取广告位投放微信群曝光量前几位
     */
    @Override
    public List<AdGroupQrcodeDTO> advertisingWechatGroupRankTop() {
        return super.getSqlSession().selectList(getStatement("advertisingWechatGroupRankTop"));
    }
}
