package com.pcloud.book.advertising.dto;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

public class AdvertisingMasterDTO extends BaseDto {

    private static final long serialVersionUID = -2269268659722737438L;

    /**
     * advertising_master.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_master.master_name (广告主名称)
     */
    private String masterName;

    /**
     * advertising_master.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * advertising_master.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * 广告结算方式列表
     */
    private List<AdvertisingSettlementMethodDTO> settlementMethodList;

    /**
     * 广告位数量
     */
    private Long spaceNum;

    /**
     * 曝光量
     */
    private Long exposureNum;

    /**
     * 点击量
     */
    private Long clickNum;

    /**
     * 点击率
     */
    private BigDecimal clickRate;

    /**
     * 累积消费
     */
    private BigDecimal totalIncome;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMasterName() {
        return masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public List<AdvertisingSettlementMethodDTO> getSettlementMethodList() {
        return settlementMethodList;
    }

    public void setSettlementMethodList(List<AdvertisingSettlementMethodDTO> settlementMethodList) {
        this.settlementMethodList = settlementMethodList;
    }

    public Long getSpaceNum() {
        return spaceNum;
    }

    public void setSpaceNum(Long spaceNum) {
        this.spaceNum = spaceNum;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    public BigDecimal getClickRate() {
        return clickRate;
    }

    public void setClickRate(BigDecimal clickRate) {
        this.clickRate = clickRate;
    }

    public BigDecimal getTotalIncome() {
        return totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    @Override
    public String toString() {
        return "AdvertisingMasterDTO{" +
                "id=" + id +
                ", masterName='" + masterName + '\'' +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", settlementMethodList=" + settlementMethodList +
                ", spaceNum=" + spaceNum +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", clickRate=" + clickRate +
                ", totalIncome=" + totalIncome +
                "} " + super.toString();
    }
}