package com.pcloud.book.clock.facade;

import com.pcloud.book.clock.entity.BookClockInfo;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: hzk
 * @Date: 2019/5/24 14:46
 * @Version 1.0
 */
@FeignClient(value = "pcloud-service-book",qualifier = "bookClockFacadeCloud",path = "bookClock")
@Api(description = "微信群打卡设置")
public interface BookClockFacade {

    @ApiOperation(value = "关联作品/应用及微信群", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
                        @ApiImplicitParam(name = "bookClockInfo", value = "打卡书籍实体", dataType = "BookClockInfo", paramType = "body")})
    @RequestMapping(value = "createBookGroupClock", method = RequestMethod.POST)
    ResponseDto<?> createBookGroupClock(@RequestHeader("token") String token, @RequestBody BookClockInfo bookClockInfo)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改关联信息", httpMethod = "POST")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookClockInfo", value = "打卡书籍实体", dataType = "BookClockInfo", paramType = "body")})
    @RequestMapping(value = "updateBookGroupClock", method = RequestMethod.POST)
    ResponseDto<?> updateBookGroupClock(@RequestHeader("token") String token, @RequestBody BookClockInfo bookClockInfo)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取关联的基本信息", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookClockInfoId", value = "bookClockInfoId", dataType = "Long", paramType = "query")})
    @RequestMapping(value = "getBookGroupClockBaseInfo", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupClockBaseInfo(@RequestHeader("token") String token,
                                             @RequestParam(value = "bookClockInfoId",required = false)Long bookClockInfoId)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取该编辑已选的超级作者作品及应用", httpMethod = "GET")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")})
    @RequestMapping(value = "getAdviserHasSelected", method = RequestMethod.GET)
    ResponseDto<?> getAdviserHasSelected(@RequestHeader("token") String token)
            throws BizException, PermissionException;

    @ApiOperation(value = "群打卡列表(编辑端)")
    @ApiImplicitParams({@ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "name", value = "打卡名称或编号", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始时间", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束时间", dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页大小", dataType = "Integer", paramType = "query")})
    @GetMapping("listBookGroupClock4Adviser")
    ResponseDto<?> listBookGroupClock4Adviser(@RequestHeader("token") String token,
                                      @RequestParam(value = "name" ,required = false) String name,
                                      @RequestParam(value = "startDate", required = false) String startDate,
                                      @RequestParam(value = "endDate", required = false) String endDate,
                                      @RequestParam(value = "currentPage", required = false) Integer currentPage,
                                      @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException ;

}
