package com.pcloud.book.copyright.dao;

import com.pcloud.book.copyright.entity.BookAuthCode;
import com.pcloud.common.core.dao.BaseDao;

/**
 * @author lily
 * @date 2018/12/4 19:31
 */
public interface BookAuthCodeDao extends BaseDao<BookAuthCode> {
    /**
     * 获取最大批次号
     */
    Integer getMaxBatchNum(Long bookId, Long channelId, Long adviserId);

    /**
     * 更新使用次数
     */
    Integer updateUseCount(Long bookId, Long channelId, Long adviserId, String code, Integer codeUseCount);

    /**
     * 获取码数量
     */
    Boolean getIsHaveCode(Long bookId, Long channelId, Long adviserId, String code);
}
