package com.pcloud.book.group.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.AppClickRecordBiz;
import com.pcloud.book.group.dao.AppClickRecordDao;
import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.string.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/30 11:58
 **/
@Component("appClickRecordBiz")
public class AppClickRecordBizImpl implements AppClickRecordBiz {

    @Autowired
    private AppClickRecordDao appClickRecordDao;
    @Autowired
    private GroupQrcodeDao groupQrcodeDao;


    @ParamLog("新增应用作品点击记录")
    @Override
    public Long createAppClickRecord(AppClickRecord appClickRecord) {
        if (appClickRecord.getQrcodeId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "群id不能为空");
        }
        if (appClickRecord.getClassifyId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "分类id不能为空！");
        }
        if (appClickRecord.getBookGroupId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "社群书id不能为空！");
        }
        if (appClickRecord.getServeId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "应用id或作品id不能为空！");
        }
        if (StringUtil.isEmpty(appClickRecord.getServeType())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "类型不能为空（APP或PRODUCT）！");
        }
        GroupQrcode groupQrcode = groupQrcodeDao.getById(appClickRecord.getQrcodeId());
        if (groupQrcode != null) {
            appClickRecord.setQrcodeId(groupQrcode.getId());
        }
        appClickRecordDao.insert(appClickRecord);
        return appClickRecord.getId();
    }
}
