package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.BookGroupClassify;
import org.codehaus.jackson.JsonParseException;
import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.vo.UpdateRankTypeVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;

/**
 * Description 社群书群二维码接口
 * Created by PENG on 2019/4/17.
 */
@FeignClient(value = "pcloud-service-book", qualifier = "bookGroupFacadeCloud", path = "bookGroup")
@Api(description = "社群书群二维码接口")
public interface BookGroupFacade {

    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "群二维码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfo", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfo(@RequestHeader("token") String token, @RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "群二维码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfo4Wechat", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfo4Wechat(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书群二维码信息", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书刊ID", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "运营ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookGroupInfoByBookId", method = RequestMethod.GET)
    ResponseDto<?> getBookGroupInfoByBookId(@RequestHeader("token") String token, @RequestParam(value = "bookId", required = false) Long bookId,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "addType", required = false) Integer addType, @RequestParam(value = "sceneId", required = false) Long sceneId) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "是否有社群码", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookId", value = "书刊ID", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "运营ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "isHaveQrcode", method = RequestMethod.GET)
    ResponseDto<Boolean> isHaveQrcode(@RequestHeader("token") String token, @RequestParam(value = "bookId", required = false) Long bookId,
                                      @RequestParam(value = "channelId", required = false) Long channelId)
            throws BizException, PermissionException, JsonParseException;



    @ApiOperation(value = "更新群二维码信息", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "用户身份信息", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroup", value = "群二维码实体", dataType = "BookGroup", paramType = "body")
    })
    @RequestMapping(value = "updateBookGroup", method = RequestMethod.POST)
    ResponseDto<?> updateBookGroup(@RequestHeader("token") String token, @RequestBody BookGroup bookGroup)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "根据社群码ID获取书名", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "bookGroupId", value = "社群码ID", dataType = "long", paramType = "query")
    })
    @RequestMapping(value = "getBookNameByBookGroupId", method = RequestMethod.GET)
    ResponseDto<?> getBookNameByBookGroupId(@RequestParam(value = "bookGroupId", required = false) Long bookGroupId)
            throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书列表(编辑)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isMainEditor", value = "只看我是主编辑", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "只看基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始时间", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束时间", dataType = "string", paramType = "query"),
    })
    @RequestMapping(value = "listBookGroup4Adviser", method = RequestMethod.GET)
    ResponseDto<PageBean> listBookGroup4Adviser(@RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "bookName", required = false) String bookName,
            @RequestParam(value = "isbn", required = false) String isbn,
            @RequestParam(value = "channelId", required = false) Long channelId,
            @RequestParam(value = "typeCode", required = false) String typeCode,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage,
            @RequestParam(value = "isMainEditor", required = false) Integer isMainEditor,
            @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
            @RequestParam(value = "bookId", required = false) Integer bookId,
            @RequestParam(value = "startDate", required = false) String startDate,
            @RequestParam(value = "endDate", required = false) String endDate)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取社群书列表(编辑)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "name", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "Integer", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "Integer", paramType = "query")
    })
    @RequestMapping(value = "listSimpleBookGroup4Adviser", method = RequestMethod.GET)
    ResponseDto<?> listSimpleBookGroup4Adviser(@RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation(value = "获取未创建社群码的书刊列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "name", value = "搜索字段", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "currentPage", value = "当前页", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "numPerPage", value = "每页条数", dataType = "int", paramType = "query")
    })
    @RequestMapping(value = "listBook4CreateBookGroup", method = RequestMethod.GET)
    ResponseDto<?> listBook4CreateBookGroup(@RequestHeader("token") String token,
            @RequestParam(value = "name", required = false) String name,
            @RequestParam(value = "currentPage", required = false) Integer currentPage,
            @RequestParam(value = "numPerPage", required = false) Integer numPerPage)
            throws BizException, PermissionException;

    @ApiOperation(value = "修改排序规则", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "updateRankTypeVO", value = "更新排序", dataType = "UpdateRankTypeVO", paramType = "body")
    })
    @PostMapping("updateRankType")
    ResponseDto<?> updateRankType(@RequestHeader("token") String token, @RequestBody UpdateRankTypeVO updateRankTypeVO)
            throws BizException, JsonParseException, PermissionException;

    @GetMapping("getRankType")
    @ApiOperation(value = "获取排序规则", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupId", value = "社群码标识", dataType = "Long", paramType = "query")
    })
    ResponseDto<Integer> getRankType(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookQrcodeId) throws BizException;

    @ApiOperation(value = "编辑获取社群码总数量", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @RequestMapping(value = "getTotalBookGroupCount", method = RequestMethod.GET)
    ResponseDto<?> getTotalBookGroupCount(@RequestHeader("token") String token) throws BizException, PermissionException, JsonParseException;

    @ApiOperation(value = "获取社群书分类列表(编辑)", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookGroupClassify", value = "群分类实体", dataType = "BookGroupClassify", paramType = "body")
    })
    @RequestMapping(value = "listSimpleBookGroupClassify4Adviser", method = RequestMethod.POST)
    ResponseDto<?> listSimpleBookGroupClassify4Adviser(@RequestHeader("token") String token,
                                               @RequestBody BookGroupClassify bookGroupClassify) throws BizException, PermissionException;

    @ApiOperation(value = "是否是特殊的出版社", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "String", paramType = "header")
    })
    @RequestMapping(value = "isSpecialAgent", method = RequestMethod.GET)
    ResponseDto<Boolean> isSpecialAgent(@RequestHeader("token") String token) throws BizException, PermissionException, JsonParseException;

    @ApiOperation("获取应用作品统计")
    @GetMapping("getAppStatistics")
    ResponseDto<?> getAppStatistics(
            @RequestHeader("token") String token,
            @RequestParam("currentPage") Integer currentPage,
            @RequestParam("numPerPage") Integer numPerPage,
            @RequestParam("bookGroupId") Long bookGroupId,
            @RequestParam(value = "qrcodeId",required = false) Long qrcodeId
    ) throws BizException, PermissionException, JsonParseException;


    @ApiOperation(value = "导出社群码(编辑)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "token", value = "token", dataType = "string", paramType = "header"),
            @ApiImplicitParam(name = "bookName", value = "书籍名称", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isbn", value = "isbn", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "channelId", value = "渠道标识", dataType = "long", paramType = "query"),
            @ApiImplicitParam(name = "typeCode", value = "书刊类型", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "isMainEditor", value = "只看我是主编辑", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "isFundSupport", value = "只看基金支持", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "bookId", value = "书籍标识", dataType = "int", paramType = "query"),
            @ApiImplicitParam(name = "startDate", value = "开始时间", dataType = "string", paramType = "query"),
            @ApiImplicitParam(name = "endDate", value = "结束时间", dataType = "string", paramType = "query"),
    })
    @RequestMapping(value = "exportGroupQrcode4Adviser", method = RequestMethod.GET)
    ResponseDto<?> exportGroupQrcode4Adviser(@RequestHeader("token") String token,
                                                @RequestParam(value = "name", required = false) String name,
                                                @RequestParam(value = "bookName", required = false) String bookName,
                                                @RequestParam(value = "isbn", required = false) String isbn,
                                                @RequestParam(value = "channelId", required = false) Long channelId,
                                                @RequestParam(value = "typeCode", required = false) String typeCode,
                                                @RequestParam(value = "isMainEditor", required = false) Integer isMainEditor,
                                                @RequestParam(value = "isFundSupport", required = false) Integer isFundSupport,
                                                @RequestParam(value = "bookId", required = false) Integer bookId,
                                                @RequestParam(value = "startDate", required = false) String startDate,
                                                @RequestParam(value = "endDate", required = false) String endDate)
            throws BizException, PermissionException;

}
