package com.pcloud.book.group.facade.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.AppClickRecordBiz;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.book.group.facade.AppClickRecordFacade;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/30 12:00
 **/
@RestController("appClickRecordFacade")
@RequestMapping("appClickRecord")
public class AppClickRecordFacadeImpl implements AppClickRecordFacade {

    @Autowired
    private AppClickRecordBiz appClickRecordBiz;

    @ApiOperation("新增应用作品点击记录")
    @PostMapping("createAppClickRecord")
    @Override
    public ResponseDto<?> createAppClickRecord(
            @RequestBody @ApiParam("应用点击记录模型") AppClickRecord appClickRecord
    ) throws BizException {
        if (appClickRecord==null){
            throw new BookBizException(BookBizException.PARAM_IS_ERROR,"参数为空！");
        }
        return new ResponseDto<>(appClickRecordBiz.createAppClickRecord(appClickRecord));
    }
}
