package com.pcloud.book.group.service.impl;

import com.pcloud.book.group.biz.BookGroupClassifyBiz;
import com.pcloud.book.group.dto.GroupClassifyQrcodeDTO;
import com.pcloud.book.group.dto.GroupQrcodeBaseDTO;
import com.pcloud.book.group.dto.ProAssocGroupAndUserNumberDTO;
import com.pcloud.book.group.service.BookGroupClassifyService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;
import java.util.Map;

/**
 * @author lily
 * @date 2019/4/28 20:23
 */
@RestController("bookGroupClassifyService")
@RequestMapping("bookGroupClassifyService")
public class BookGroupClassifyServiceImpl implements BookGroupClassifyService {
    @Autowired
    private BookGroupClassifyBiz bookGroupClassifyBiz;

    @Override
    @GetMapping("getClassifyQrcodeInfo")
    public ResponseEntity<ResponseDto<GroupClassifyQrcodeDTO>> getClassifyQrcodeInfo(@RequestParam("weixinGroupId") String weixinGroupId) {
        GroupClassifyQrcodeDTO groupClassifyQrcodeDTO = bookGroupClassifyBiz.getClassifyQrcodeInfo(weixinGroupId);
        return ResponseHandleUtil.toResponse(groupClassifyQrcodeDTO);
    }

    @Override
    @PostMapping("listGroupQrcodeBaseInfo")
    public ResponseEntity<ResponseDto<Map<String, GroupQrcodeBaseDTO>>> listGroupQrcodeBaseInfo(@RequestBody List<String> weixinGroupIds) {
        Map<String, GroupQrcodeBaseDTO> groupQrcodeMap =  bookGroupClassifyBiz.listGroupQrcodeBaseInfo(weixinGroupIds);
        return ResponseHandleUtil.toResponse(groupQrcodeMap);
    }

    @Override
    @GetMapping("getProAssocGroupAndUserNumber")
    public ResponseEntity<ResponseDto<ProAssocGroupAndUserNumberDTO>> getProAssocGroupAndUserNumber(@RequestParam("productId") Long productId) {
        ProAssocGroupAndUserNumberDTO proAssocGroupAndUserNumberDTO = bookGroupClassifyBiz.getProAssocGroupAndUserNumber(productId);
        return ResponseHandleUtil.toResponse(proAssocGroupAndUserNumberDTO);
    }
}
