package com.pcloud.book.keywords.dao;

import com.pcloud.book.keywords.dto.KeywordDTO;
import com.pcloud.book.keywords.dto.ReplyKeywordDTO;
import com.pcloud.book.keywords.entity.BookKeyword;
import com.pcloud.book.keywords.vo.KeywordVO;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @author lily
 * @date 2019/4/25 11:33
 */
public interface BookKeywordDao extends BaseDao<BookKeyword> {
    
    /**
     * @Author:lili
     * @Desr:删除社群码配置关键词
     * @Date:2019/4/25 14:48
     */
    void deleteById(Long keywordId, Long partyId);

    /**
     * @Author:lili
     * @Desr:设置排序值
     * @Date:2019/4/25 14:51
     */
    void setRank(BookKeyword bookKeyword);

    /**
     * @Author:lili
     * @Desr:获取最大的排序值
     * @Date:2019/4/25 14:53
     */
    Integer getMaxRank(Long bookGroupId, Long classifyId);

    /**
     * @Author:lili
     * @Desr:获取5个关键词
     * @Date:2019/5/5 15:16
     */
    List<KeywordDTO> listFiveKeyword(Long classifyId, Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:获取匹配的关键词
     * @Date:2019/5/6 10:15
     */
    ReplyKeywordDTO getKeywordId(Long classifyId, Long bookGroupId, String content);

    /**
     * @Author:lili
     * @Desr:校验关键词
     * @Date:2019/5/6 14:47
     */
    Boolean checkKeyword(String keywords, Long classifyId, Long bookGroupId, Long keywordId);

    /**
     * @Author:lili
     * @Desr:获取关键词基本信息
     * @Date:2019/5/6 15:03
     */
    KeywordVO getByBookKeyword(Long bookKeywordId);

    /**
     * @Author:lili
     * @Desr:获取关键词数量
     * @Date:2019/5/14 16:46
     */
    Integer getKeywordCount(Long bookGroupId, Long classifyId);
}
