package com.pcloud.book.keywords.facade.impl;

import com.pcloud.book.keywords.biz.BookGuideBiz;
import com.pcloud.book.keywords.facade.BookGuideFacade;
import com.pcloud.book.keywords.vo.GuideVO;
import com.pcloud.book.keywords.vo.SetGuideVO;
import com.pcloud.book.keywords.vo.UpdateGuideVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import com.pcloud.common.utils.SessionUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author lily
 * @date 2019/4/23 15:24
 */
@RestController("bookGuideFacade")
@RequestMapping("bookGuide")
public class BookGuideFacadeImpl implements BookGuideFacade {

    @Autowired
    private BookGuideBiz bookGuidBiz;

    @Override
    @PostMapping("insertGuide")
    public ResponseDto<?> insertGuide(@RequestHeader("token") String token, @RequestBody SetGuideVO setGuideVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGuidBiz.insertGuide(setGuideVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @PostMapping("updateGuide")
    public ResponseDto<?> updateGuide(@RequestHeader("token") String token, @RequestBody UpdateGuideVO updateGuideVO) throws BizException, PermissionException {
        Long partyId = (Long) SessionUtil.getVlaue(token, SessionUtil.PARTY_ID);
        bookGuidBiz.updateGuide(updateGuideVO, partyId);
        return new ResponseDto<>();
    }

    @Override
    @GetMapping("getGuideByBookGroup")
    public ResponseDto<GuideVO> getGuideByBookGroup(@RequestHeader("token") String token, @RequestParam("bookGroupId") Long bookGroupId) throws BizException, PermissionException {
        GuideVO guideVO =  bookGuidBiz.getGuideByBookGroup(bookGroupId);
        return new ResponseDto<>(guideVO == null ? new GuideVO() : guideVO);
    }

    @Override
    @GetMapping("getGuideByClassify")
    public ResponseDto<GuideVO> getGuideByClassify(@RequestHeader("token") String token, @RequestParam("classifyId") Long classifyId) throws BizException, PermissionException {
        GuideVO guideVO =  bookGuidBiz.getGuideByClassify(classifyId);
        return new ResponseDto<>(guideVO == null ? new GuideVO() : guideVO);
    }
}
