package com.pcloud.book.push.dao;

import com.pcloud.book.push.entity.PushGroup;
import com.pcloud.common.core.dao.BaseDao;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 17:46
 **/
public interface PushGroupDao extends BaseDao<PushGroup> {
    /**
     * 批量插入
     */
    Integer batchInsert(List<PushGroup> pushGroups);

    /**
     * 根据pushId查询列表
     */
    List<PushGroup> getListByPushId(Long pushId);

    /**
     * 根据pushId删除
     * @param pushId
     * @param partyId
     */
    void deleteByPushId(Long pushId, Long partyId);

    /**
     * 批量删除
     * @param ids
     * @param partyId
     */
    void deleteByIds(List<Long> ids, Long partyId);

    /**
     * 根据群发id集合获取群发关联集合
     * @param pushIds
     * @return
     */
    List<PushGroup> getListByPushIds(List<Long> pushIds);
}
