package com.pcloud.book.push.entity;

import com.pcloud.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/4/17 15:41
 **/
@ApiModel("消息推送模型")
public class Push extends BaseEntity {

    @ApiModelProperty("发送类型（1:立即发送 2:单次发送 3:每天发送）")
    private Integer pushType;

    @ApiModelProperty("发送时间")
    private String pushTime;

    @ApiModelProperty("是否删除")
    private Boolean isDelete;

    @ApiModelProperty("创建人")
    private Long createUser;

    @ApiModelProperty("更新人")
    private Long updateUser;

    @ApiModelProperty("推送群集合")
    private List<PushGroup> pushGroups;

    @ApiModelProperty("推送消息项集合")
    private List<PushItem> pushItems;

    public Integer getPushType() {
        return pushType;
    }

    public void setPushType(Integer pushType) {
        this.pushType = pushType;
    }

    public String getPushTime() {
        return pushTime;
    }

    public void setPushTime(String pushTime) {
        this.pushTime = pushTime;
    }

    public Boolean getIsDelete() {
        return isDelete;
    }

    public void setIsDelete(Boolean isDelete) {
        this.isDelete = isDelete;
    }

    public Long getCreateUser() {
        return createUser;
    }

    public void setCreateUser(Long createUser) {
        this.createUser = createUser;
    }

    public Long getUpdateUser() {
        return updateUser;
    }

    public void setUpdateUser(Long updateUser) {
        this.updateUser = updateUser;
    }

    public List<PushGroup> getPushGroups() {
        return pushGroups;
    }

    public void setPushGroups(List<PushGroup> pushGroups) {
        this.pushGroups = pushGroups;
    }

    public List<PushItem> getPushItems() {
        return pushItems;
    }

    public void setPushItems(List<PushItem> pushItems) {
        this.pushItems = pushItems;
    }

    @Override
    public String toString() {
        return "Push{" +
                "pushType=" + pushType +
                ", pushTime='" + pushTime + '\'' +
                ", isDelete=" + isDelete +
                ", createUser=" + createUser +
                ", updateUser=" + updateUser +
                ", pushGroups=" + pushGroups +
                ", pushItems=" + pushItems +
                "} " + super.toString();
    }
}
