package com.pcloud.book.adnews.dao.impl;

import com.pcloud.book.adnews.dao.AdNewsChooseDao;
import com.pcloud.book.adnews.entity.AdNewsChoose;
import com.pcloud.common.core.dao.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/7/17 16:17
 **/
@Repository("adNewsChooseDao")
public class AdNewsChooseDaoImpl extends BaseDaoImpl<AdNewsChoose> implements AdNewsChooseDao {
    @Override
    public Integer batchInsert(List<AdNewsChoose> list) {
        return super.getSqlSession().insert(getStatement("batchInsert"), list);
    }

    @Override
    public void deleteAdNewsChooseById(Long adNewsId, Long partyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("adNewsId",adNewsId);
        map.put("partyId",partyId);
        super.getSqlSession().update(getStatement("deleteAdNewsChooseById"), map);
    }

    @Override
    public Integer getCountByAdNewsIdsAndPartyId(List<Long> adNewsIds, Long partyId) {
        Map<String,Object> map=new HashMap<>();
        map.put("adNewsIds",adNewsIds);
        map.put("partyId",partyId);
        return super.getSqlSession().selectOne(getStatement("getCountByAdNewsIdsAndPartyId"), map);
    }
}
