package com.pcloud.book.book.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.pcloud.book.book.biz.BookResourceBiz;
import com.pcloud.book.book.dto.BookResourceDto;
import com.pcloud.book.book.service.BookResourceService;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.utils.ResponseHandleUtil;

/**
 * 图书资源
 * 
 * @author:lili
 * @date 创建时间：2017年3月21日 上午11:36:50
 * @version 1.0
 * @return
 */
@RestController("bookResourceService")
@RequestMapping("bookResourceService")
public class BookResourceServiceImpl implements BookResourceService {

	@Autowired
	private BookResourceBiz bookResourceBiz;

	/**
	 * 获取图书关联资源
	 */
	@Override
	@RequestMapping(value = "/listBookResource", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<BookResourceDto>>> listBookResource(
			@RequestParam(value = "bookId", required = false) Long bookId,
			@RequestParam(value = "channelId", required = false) Long channelId,
			@RequestParam(value = "adviserId", required = false) Long adviserId) {
		return ResponseHandleUtil.toResponse(bookResourceBiz.listBaseById(bookId, adviserId, channelId));
	}

	/**
	 * 获取资源关联的图书
	 */
	@Override
	@RequestMapping(value = "/listByResourceId", method = RequestMethod.GET)
	public ResponseEntity<ResponseDto<List<Long>>> listByResourceId(@RequestParam("resourceId") Long resourceId) {
		return ResponseHandleUtil.toResponse(bookResourceBiz.listByResourceId(resourceId));
	}
}
