package com.pcloud.book.group.biz.impl;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.book.group.biz.AppClickRecordBiz;
import com.pcloud.book.group.dao.AppClickRecordDao;
import com.pcloud.book.group.dao.GroupQrcodeDao;
import com.pcloud.book.group.dto.CountAndTimeDTO;
import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.book.group.entity.GroupQrcode;
import com.pcloud.book.group.set.GroupSet;
import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.utils.string.StringUtil;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description
 * @Author ruansiyuan
 * @Date 2019/5/30 11:58
 **/
@Component("appClickRecordBiz")
public class AppClickRecordBizImpl implements AppClickRecordBiz {

    @Autowired
    private AppClickRecordDao appClickRecordDao;
    @Autowired
    private GroupQrcodeDao groupQrcodeDao;
    @Autowired
    private GroupSet groupSet;


    @Override
    public Long createAppClickRecord(AppClickRecord appClickRecord) {
        if (appClickRecord.getBookGroupId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "社群书id不能为空！");
        }
        if (appClickRecord.getServeId() == null) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "应用id或作品id不能为空！");
        }
        if (StringUtil.isEmpty(appClickRecord.getServeType())) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "类型不能为空（APP或PRODUCT）！");
        }
        if (appClickRecord.getQrcodeId()!=null){
            GroupQrcode groupQrcode = groupQrcodeDao.getById(appClickRecord.getQrcodeId());
            if (groupQrcode != null) {
                appClickRecord.setWeixinGroupId(groupQrcode.getWeixinGroupId());
            }
        }
        appClickRecordDao.insert(appClickRecord);
        return appClickRecord.getId();
    }

    @ParamLog("根据类型按照时间获取资源服务点击人数")
    @Override
    public List<CountAndTimeDTO> getAppClickByTime(Integer joinGroupType, Integer timeType, String startTime, String endTime) {
        if (timeType == null || (1 != timeType && 2 != timeType)) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "时间类型参数错误！");
        }
        if (StringUtil.isEmpty(startTime) || StringUtil.isEmpty(endTime)) {
            throw new BookBizException(BookBizException.PARAM_IS_ERROR, "时间参数错误！");
        }
        List<CountAndTimeDTO> list = appClickRecordDao.getAppClickByTime(joinGroupType, timeType, startTime, endTime);
        groupSet.fillEmptyTime(list, timeType, startTime, endTime);
        list = list.stream().sorted(Comparator.comparing(CountAndTimeDTO::getTime)).collect(Collectors.toList());
        return list;
    }
}
