package com.pcloud.book.group.facade;

import com.pcloud.book.group.entity.AppClickRecord;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;

@Api(description = "应用作品点击记录")
public interface AppClickRecordFacade {

    @ApiOperation("新增应用作品点击记录")
    @PostMapping("createAppClickRecord")
    ResponseDto<?> createAppClickRecord(
            @CookieValue("userInfo") String userInfo,
            @RequestBody @ApiParam("应用点击记录模型") AppClickRecord appClickRecord
    ) throws BizException;

    @ApiOperation("根据类型按照时间获取资源服务点击人数")
    @GetMapping("getAppClickByTime")
    ResponseDto<?> getAppClickByTime(
            @RequestHeader("token") String token,
            @RequestParam(value = "joinGroupType", required = false) Integer joinGroupType,
            @RequestParam("timeType") @ApiParam("时间类型（1按天，2按小时）") Integer timeType,
            @RequestParam("startTime") @ApiParam("开始时间") String startTime,
            @RequestParam("endTime") @ApiParam("结束时间") String endTime
    ) throws BizException, PermissionException;

}
