package com.pcloud.book.push.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.entity.BaseEntity;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("个人号群发项")
@Data
public class SelfPushItem extends BaseEntity{

    @ApiModelProperty("推送id")
    private Long pushId;

    @ApiModelProperty("推送内容项类型：1文本,2链接,3应用,4图片")
    private Integer itemType;

    @ApiModelProperty("文本内容")
    private String textContent;

    @ApiModelProperty("链接地址")
    private String linkUrl;

    @ApiModelProperty("链接标题")
    private String linkTitle;

    @ApiModelProperty("链接简介")
    private String linkDescription;

    @ApiModelProperty("链接图片地址")
    private String linkImageUrl;

    @ApiModelProperty("图片链接")
    private String imageUrl;

    @ApiModelProperty("应用id")
    private Long appId;

    @ApiModelProperty("作品id")
    private Long productId;

    @ApiModelProperty("应用链接")
    private String appUrl;

    @ApiModelProperty("作品链接")
    private String productUrl;

    @ApiModelProperty("发送状态（0发送中1发送成功2发送失败）")
    private Integer pushStatus;

    @ApiModelProperty("创建人")
    private Long createUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改人")
    private Long updateUser;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @ApiModelProperty("修改时间")
    private Date updateTime;


}