/**
 * 
 */
package com.pcloud.common.core.aspect;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.core.annotation.AliasFor;

/**
 * 
 * @author：songx
 * @date：2018年4月26日,下午2:26:06
 */
@Target({ ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface ParamLog {

	/**
	 * 默认值
	 * 
	 * @return
	 */
	@AliasFor("description")
	String value() default "";

	/**
	 * 是否输出入参
	 * 
	 * @return
	 */
	boolean isBefore() default true;

	/**
	 * 是否输出返回值
	 * 
	 * @return
	 */
	boolean isAfterReturn() default true;

	/**
	 * 描述
	 * 
	 * @return
	 */
	@AliasFor("value")
	String description() default "";

}
