package com.pcloud.common.core.biz;

import org.springframework.amqp.core.AmqpTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.common.core.aspect.ParamLog;
import com.pcloud.common.core.constant.MQQueueConstant;
import com.pcloud.common.core.dto.LabelUsedMessageDto;
import com.pcloud.common.exceptions.BizException;

/**
 * @描述： 标签使用队列实现类 @作者： shuyh @创建时间： 2017年5月23日 @版本：1.0
 */
@Component("labelUsedQueueBiz")
public class LabelUsedQueueBizImpl implements LabelUsedQueueBiz {

	@Autowired
	private AmqpTemplate amqpTemplate;

	@Override
	@ParamLog("标签使用QUEUE")
	public void sendMessageQueue(LabelUsedMessageDto labelUsedMessageDto) throws BizException {
		amqpTemplate.convertAndSend(MQQueueConstant.LABEL_USED, labelUsedMessageDto);
	}

}
