package com.pcloud.common.core.dto;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonFormat;

import javax.xml.bind.annotation.XmlElement;
import java.io.Serializable;
import java.util.Date;

/**
 * @描述：SAYS动态附件
 * @作者：lucas
 * @创建时间：2017年12月14日,9:37
 * @版本：1.0
 */
public class DynamicAccessoryDto implements Serializable {

    private static final long serialVersionUID = -4404336476045121300L;
    /**
     * 附件ID
     */
    private Long accessoryId;

    /**
     * 动态ID
     */
    private Long dynamicId;

    /**
     * 附件序号
     */
    private String accessoryNo;

    /**
     * 附件类型
     */
    private String accessoryType;

    /**
     * 附件内容
     */
    private String accessoryContent;

    /**
     * 附件时长
     */
    private String accessoryTime;

    /**
     * 创建时间
     */
    private Date createDate;

    public Long getAccessoryId() {
        return accessoryId;
    }

    public void setAccessoryId(Long accessoryId) {
        this.accessoryId = accessoryId;
    }

    public Long getDynamicId() {
        return dynamicId;
    }

    public void setDynamicId(Long dynamicId) {
        this.dynamicId = dynamicId;
    }

    public String getAccessoryNo() {
        return accessoryNo;
    }

    public void setAccessoryNo(String accessoryNo) {
        this.accessoryNo = accessoryNo;
    }

    public String getAccessoryType() {
        return accessoryType;
    }

    public void setAccessoryType(String accessoryType) {
        this.accessoryType = accessoryType;
    }

    public String getAccessoryContent() {
        return accessoryContent;
    }

    public void setAccessoryContent(String accessoryContent) {
        this.accessoryContent = accessoryContent;
    }

    public String getAccessoryTime() {
        return accessoryTime;
    }

    public void setAccessoryTime(String accessoryTime) {
        this.accessoryTime = accessoryTime;
    }

    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @XmlElement
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Override
    public String toString() {
        return "DynamicAccessory{" + "accessoryId=" + accessoryId + ", dynamicId=" + dynamicId + ", accessoryNo='" + accessoryNo + '\'' + ", accessoryType='" + accessoryType + '\''
                + ", accessoryContent='" + accessoryContent + '\'' + ", createDate=" + createDate + '}';
    }
}
