package com.pcloud.common.core.mybatis.cache.redis;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.exceptions.JedisConnectionException;

/**
 * ClassName: CachePool <br/>
 * Function:  redis 初始化与连接池实现<br/>
 * <per>
 * 由于需结合Mybatis实现 不与Spring redis注解实现混用。
 * 与Spring redis注解实现 各独立实现各自功能。
 * </per>
 * date: 2014-8-13 下午4:49:36 <br/>
 * 
 * @author laich
 */
/**
 * @描述：redis 初始化与连接池实现<br/>
 * <per>
 * 由于需结合Mybatis实现 不与Spring redis注解实现混用。
 * 与Spring redis注解实现 各独立实现各自功能。
 * </per>
 * @作者：DiSeng.H
 * @创建时间：2016年3月11日,下午4:12:46
 * @版本：1.0
 */
public class CachePool {

	JedisSentinelPool pool;
	private static final CachePool cachePool = new CachePool();
	// private RedisUtils readisUtils = new RedisUtils();

	/** 单例模式 */
	public static CachePool getInstance() {
		return cachePool;
	}

	/** 初始化 */
	// private CachePool() {
	// pool = readisUtils.getJedisSentinelPool();
	// }

	@SuppressWarnings("deprecation")
	public Jedis getJedis() {
		Jedis jedis = null;
		boolean borrowOrOprSuccess = true;
		try {
			jedis = pool.getResource();
		} catch (JedisConnectionException e) {
			borrowOrOprSuccess = false;
			if (jedis != null)
				pool.returnBrokenResource(jedis);
		} finally {
			if (borrowOrOprSuccess)
				pool.returnResource(jedis);
		}
		jedis = pool.getResource();
		return jedis;
	}

	public JedisSentinelPool getJedisPool() {
		return this.pool;
	}
}
