/**
 * 
 */
package com.pcloud.common.config;

import java.util.Map;

import com.pcloud.common.utils.ResourceUtils;

/**
 * 环境配置基础类
 * @author diseng
 *
 */ 
public class PublicConfig {
	/**
	 * 系统文件配置 加载。
	 */
	public static Map<String, String> PUBLIC_USER = ResourceUtils.getResource("public_user").getMap();  

	/**
	 * 系统文件配置 加载。
	 */
	public static Map<String, String> PUBLIC_SYSTEM = ResourceUtils.getResource("public_system").getMap();
	
	/**
	 * 密码错误限制次数
	 */
	public final static Integer PWD_ERROR_LIMIT_TIMES = Integer.parseInt(PUBLIC_USER.get("PWD_ERROR_LIMIT_TIMES"));

	/**
	 * 密码错误限制时间（分钟）
	 */
	public final static Integer PWD_ERROR_LIMIT_TIME = Integer.parseInt(PUBLIC_USER.get("PWD_ERROR_LIMIT_TIME"));

	/**
	 * 门户是否使用验证码 配合密码错误次数值使用
	 */
	public final static boolean IS_USE_KAPTCHA = Boolean.parseBoolean(PUBLIC_USER.get("IS_USE_KAPTCHA"));

	/**
	 * 密码错误次数值 将 出现验证码，如果值为0 则永远不会出现验证码
	 */
	public final static Integer PWD_TIMES_USE_KAPTCHA = Integer.parseInt(PUBLIC_USER.get("PWD_TIMES_USE_KAPTCHA"));

	/**
	 * 是否开发状态
	 */
	public final static boolean IS_DEV_STATUS = Boolean.parseBoolean(PUBLIC_USER.get("IS_DEV_STATUS"));

	
}
