package com.pcloud.common.utils.cache.redis;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @描述：将用户会话信息保存在Redis中的工具类
 * @作者：DiSeng.H
 * @创建时间：2016年3月10日,下午1:19:04
 * @版本：1.0
 */
public class RedisSessionUtils {
	
	private static Logger logger = LoggerFactory.getLogger(RedisSessionUtils.class);
	
	/**
	 * 保存session
	 * 
	 * @param sessionId
	 * @param sessionObj
	 * @param seconds
	 *            超时秒数，如果为null则默认为30分钟
	 * @return
	 */
	public static boolean saveSession(String sessionId, Map<String, Object> sessionObj, Integer seconds) {
		boolean result = false;
		try {
			result = JedisClusterUtils.setObject(sessionId, sessionObj, seconds);
		} catch (Exception e) {
			logger.error("缓存删除失败：" + e);
		}
		return result;
	}

	/**
	 * 删除session
	 * 
	 * @param sessionId
	 * @return
	 */
	public static boolean deleteSession(String sessionId) {
		boolean result = false;
		try {
			result = JedisClusterUtils.delObject(sessionId);
		} catch (Exception e) {
			logger.error("缓存删除失败：" + e);
		}
		return result;
	}

	/**
	 * 取session
	 * 
	 * @param sessionId
	 * @return
	 */
	public static Map<String, Object> getSession(String sessionId) {
		Map<String, Object> sessionObj = null;
		try {
			sessionObj = JedisClusterUtils.getMap(sessionId, String.class, Object.class);
		} catch (Exception e) {
			logger.error("缓存读取失败：" + e);
		}
		return sessionObj;
	}

	/**
	 * 更新session超时时间
	 * 
	 * @param sessionId
	 * @param seconds
	 * @return
	 */
	public static boolean updateSessionTime(String sessionId, Integer seconds) {
		boolean result = false;
		try {
			result = JedisClusterUtils.expireObject(sessionId, seconds);
		} catch (Exception e) {
			logger.error("缓存时间更新失败：" + e);
		}
		return result;
	}
	
}
