package com.pcloud.solr;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.apache.solr.client.solrj.beans.Field;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * Description solr索引DTO
 * @author PENG
 * @date 2018/4/24
 */
public class SolrDto implements Serializable {

    private static final long serialVersionUID = -1552260448520217079L;

    /**
     * 索引唯一标识
     */
    @Field
    private String id;

    /**
     * 索引对象ID
     */
    @Field
    private Long saleId;

    /**
     * 索引对象编码
     */
    @Field
    private String saleCode;

    /**
     * 名称
     */
    @Field
    private String title;

    /**
     * 类型ID
     */
    @Field
    private Long typeId;

    /**
     * 类型编码
     */
    @Field
    private String typeCode;

    /**
     * 类型名称
     */
    @Field
    private String typeName;

    /**
     * 开始时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @Field
    private Date startDate;

    /**
     * 结束时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @Field
    private Date endDate;

    /**
     * 是否允许出售
     */
    @Field
    private Integer saleState;

    /**
     * 封面
     */
    @Field
    private String coverImg;

    /**
     * 简介
     */
    @Field
    private String description;

    /**
     * 创建人
     */
    @Field
    private Long createdUser;

    /**
     * 创建时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @Field
    private Date createdDate;

    /**
     * 最近修改时间
     */
    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @Field
    private Date lastModifiedDate;

    /**
     * 运营ID
     */
    @Field
    private Long channelId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getSaleId() {
        return saleId;
    }

    public void setSaleId(Long saleId) {
        this.saleId = saleId;
    }

    public String getSaleCode() {
        return saleCode;
    }

    public void setSaleCode(String saleCode) {
        this.saleCode = saleCode;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Long getTypeId() {
        return typeId;
    }

    public void setTypeId(Long typeId) {
        this.typeId = typeId;
    }

    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getStartDate() {
        return startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getEndDate() {
        return endDate;
    }

    public void setEndDate(Date endDate) {
        if (null != endDate) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(endDate);
            if (calendar.get(Calendar.HOUR_OF_DAY) == 0 && calendar.get(Calendar.MINUTE) == 0 && calendar.get(Calendar.SECOND) == 0) {
                calendar.set(Calendar.HOUR_OF_DAY, 23);
                calendar.set(Calendar.MINUTE, 59);
                calendar.set(Calendar.SECOND, 59);
            }
            this.endDate = calendar.getTime();
        } else {
            this.endDate = null;
        }
    }

    public String getCoverImg() {
        return coverImg;
    }

    public void setCoverImg(String coverImg) {
        this.coverImg = coverImg;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCreatedUser() {
        return createdUser;
    }

    public void setCreatedUser(Long createdUser) {
        this.createdUser = createdUser;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getCreatedDate() {
        return createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public Long getChannelId() {
        return channelId;
    }

    public void setChannelId(Long channelId) {
        this.channelId = channelId;
    }

    @JsonFormat(
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    public Date getLastModifiedDate() {
        return lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Integer getSaleState() {
        return saleState;
    }

    public void setSaleState(Integer saleState) {
        this.saleState = saleState;
    }

    @Override
    public String toString() {
        return "SolrDto{" +
                "id='" + id + '\'' +
                ", saleId=" + saleId +
                ", saleCode='" + saleCode + '\'' +
                ", title='" + title + '\'' +
                ", typeId=" + typeId +
                ", typeCode='" + typeCode + '\'' +
                ", typeName='" + typeName + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", saleState=" + saleState +
                ", coverImg='" + coverImg + '\'' +
                ", description='" + description + '\'' +
                ", createdUser=" + createdUser +
                ", createdDate=" + createdDate +
                ", lastModifiedDate=" + lastModifiedDate +
                ", channelId=" + channelId +
                '}';
    }
}
