package com.pcloud.book.advertising.biz;

import com.pcloud.book.advertising.dto.AdvertisingMasterDTO;
import com.pcloud.book.advertising.dto.Book4AdvertisingMasterDTO;
import com.pcloud.book.advertising.dto.GroupMasterAddDTO;
import com.pcloud.book.advertising.dto.GroupMasterDTO;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBeanNew;

import java.util.List;
import java.util.Map;

/**
 * @描述：微信群标记广告主
 * @作者：zhuyajie
 * @创建时间：18:47 2019/8/22
 * @版本：1.0
 */
public interface GroupMasterTagBiz {

    /**
     * 微信群广告主标记列表
     * @param currentPage
     * @param numPerPage
     * @param paramMap
     * @return
     */
    PageBeanNew<GroupMasterDTO> listPageGroupMaster(Integer currentPage, Integer numPerPage, Map<String, Object> paramMap);

    /**
     * 获取品牌方广告主
     * @return
     * @throws BizException
     */
    List<AdvertisingMasterDTO> getBrandMaster() throws BizException;

    /**
     * 微信群标记广告主
     * @param groupMasterAddDTO
     */
    void setGroupMaster(GroupMasterAddDTO groupMasterAddDTO);

    /**
     * 广告主标记-图书列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @return
     */
    PageBeanNew<Book4AdvertisingMasterDTO> listPageBook4AdMaster(Integer currentPage, Integer numPerPage, String name);

    /**
     * 品牌方广告主-微信群列表
     * @param userId
     * @param currentPage
     * @param numPerPage
     * @param paramMap
     * @return
     */
    PageBeanNew<GroupMasterDTO> listPageGroupList4Master(Long userId, Integer currentPage, Integer numPerPage, Map<String, Object> paramMap);

    /**
     * 微信群广告主标记列表-导出
     * @param name
     * @param proLabelId
     * @param depLabelId
     * @param purLabelId
     * @param masterId
     */
    void exportGroupMaster(String name, Long proLabelId, Long depLabelId, Long purLabelId, Long masterId, Long partyId);

    /**
     * 品牌方广告主-微信群导出
     * @param partyId
     * @param paramMap
     */
    void exportGroupList4Master(Long partyId, Map<String, Object> paramMap, Long userId);

    /**
     * 根据登录用户获取标记的微信群列表
     * @param userId
     * @return
     */
    List<String> getTagWxGroupIdsByUserId(Long userId);

    /**
     * 品牌方广告主-微信群基本信息列表
     * @param currentPage
     * @param numPerPage
     * @param name
     * @param userId
     * @return
     */
    PageBeanNew<GroupMasterDTO> listPageGroupBaseInfo4Master(Integer currentPage, Integer numPerPage, String name, Long userId);

    /**
     * 修改广告主的登录id
     * @param masterId
     * @param loginId
     */
    void updateMasterLoginId(Long masterId, Long loginId);

    /**
     * 广告主已标记的书刊id
     * @param masterId
     * @return
     */
    List<Long> getTagBookIds4AdMatser(Long masterId);

    /**
     * 已标记的书标记新的群
     * @param classifyId
     * @param qrcodeId
     */
    public void addTagByBookGroup(Long classifyId, Long qrcodeId);
}
