package com.pcloud.book.group.biz;

import com.pcloud.book.book.dto.BookDto;
import com.pcloud.book.group.dto.*;

import com.pcloud.book.group.dto.AppStatisticsDTO;
import com.pcloud.book.group.dto.BookGroupDTO;
import com.pcloud.book.group.dto.ClassifyKeywordDTO;
import com.pcloud.book.group.dto.GroupStoreMyPayDto;
import com.pcloud.book.group.dto.QrcodeNameAndProIdDTO;
import com.pcloud.book.group.entity.BookGroup;
import com.pcloud.book.group.vo.*;

import com.pcloud.book.group.entity.BookGroup;

import com.pcloud.book.group.vo.*;

import com.pcloud.book.group.vo.StatisticVO;
import com.pcloud.common.dto.StoreFlowInfoDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.page.PageBean;
import com.pcloud.common.page.PageBeanNew;
import com.pcloud.common.page.PageParam;

import java.util.List;
import java.util.Map;

/**
 * Description 社群书群二维码业务逻辑层接口
 * Created by PENG on 2019/4/17.
 */
public interface BookGroupBiz {


    /**
     * 查询编辑是否有此社群书
     * @param bookId
     * @param channelId
     * @param adviserId
     * @return
     */
    BookGroupDTO getDTOByBookId(Long bookId, Long channelId, Long adviserId);
    /**
     * 创建社群书时生成群二维码
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    BookGroup createBookGroupAfterCreateBook(Long bookId, Long channelId, Long adviserId, Integer addType, Long sceneId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo(Long bookGroupId) throws BizException;

    /**
     * 批量获取社群书群二维码信息
     * @param bookGroupIds 群二维码ID列表
     * @return
     * @throws BizException
     */
    Map<Long, BookGroupDTO> getBookGroupInfoByIds(List<Long> bookGroupIds) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookGroupId 群二维码ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfo4Wechat(Long bookGroupId) throws BizException;

    /**
     * 获取社群书群二维码信息
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    BookGroupDTO getBookGroupInfoByBookId(Long bookId, Long channelId, Long adviserId, Integer addType, Long sceneId) throws BizException;

    /**
     * 更新群二维码信息
     * @param bookGroup 群二维码实体
     * @throws BizException
     */
    void updateBookGroup(BookGroup bookGroup) throws BizException;

    /**
     * 根据书刊ID删除
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void deleteByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 根据书刊ID恢复
     * @param bookId    书刊ID
     * @param channelId 运营ID
     * @param adviserId 编辑ID
     * @throws BizException
     */
    void recoverByBookId(Long bookId, Long channelId, Long adviserId) throws BizException;

    /**
     * 关联社群码和社群书
     * @param bookId      书刊ID
     * @param bookGroupId 社群码ID
     * @param adviserId   编辑ID
     * @throws BizException
     */
    void linkBookGroup(Long bookId, Long bookGroupId, Long adviserId) throws BizException;

    /**
     * 根据社群码ID获取书名
     * @param bookGroupId 社群码ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getBookNameByBookGroupId(Long bookGroupId) throws BizException;

    /**
     * 获取社群书列表(编辑)
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    PageBean listBookGroup4Adviser(Map<String, Object> paramMap, PageParam pageParam, Long adviserId) throws BizException;

    /**
    * @description 获取社群书列表(运营)
    * @author 戴兴
    * @date 2019/7/23 15:39
    */
    PageBean listBookGroup4Channel(Long channelId, ListBookGroup4ChannelParamVO listBookGroup4ChannelParamVO);

    /**
     * 获取社群书列表(编辑)
     * @param paramMap 参数Map
     * @return
     * @throws BizException
     */
    List<BookDto> listSimpleBookGroup4Adviser(Map<String, Object> paramMap) throws BizException;

    /**
     * 获取社群书列表(编辑)
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @return
     * @throws BizException
     */
    PageBean listSimpleBookGroup4Adviser(Map<String, Object> paramMap, PageParam pageParam) throws BizException;

    /**
     * 获取未创建社群码的书刊列表
     * @param paramMap  参数Map
     * @param pageParam 分页参数
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    PageBean listBook4CreateBookGroup(Map<String, Object> paramMap, PageParam pageParam, Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取群二维码名称以及商品id
     * @Date:2019/4/18 9:57
     */
    QrcodeNameAndProIdDTO getQrcodeNameAndProId(Long bookGroupId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取排序方式
     * @Date:2019/4/19 14:57
     */
    Integer getRankType(Long bookGroupId) throws BizException;

    /**
     * @Author:lili
     * @Desr:更新排序方式
     * @Date:2019/4/19 14:58
     */
    void updateRankType(Long bookGroupId, Integer rankType) throws BizException;

    /**
     * 编辑获取社群码总数量
     * @param adviserId 编辑ID
     * @return
     * @throws BizException
     */
    Map<String, Object> getTotalBookGroupCount(Long adviserId) throws BizException;

    /**
     * @Author:lili
     * @Desr:获取备用二维码
     * @Date:2019/5/13 15:09
     */
    String getSpareQr(Long bookGroupId);

    /**
     * @Author:lili
     * @Desr:根据二维码获取社群码基本信息
     * @Date:2019/5/27 17:59
     */
    BookGroupDTO getBaseInfoBySceneId(Long sceneId);

    /**
    * @description 更新个人二维码
    * @author 戴兴
    * @date 2019/8/7 16:30
    */
    void updatePersonQrcode(PersonalQrcodeDTO personalQrcodeDTO);

    /**
     * @Author:lili
     * @Desr:是否是特殊的出版社
     * @Date:2019/5/28 11:14
     */
    Boolean isSpecialAgent(Long agentId);

    /**
     * @Author:lili
     * @Desr:是否有社群码
     * @Date:2019/5/30 16:36
     */
    Boolean isHaveQrcode(Long bookId, Long channelId, Long adviserId);


    /**
     * 获取应用作品统计
     * @param currentPage
     * @param numPerPage
     * @param bookGroupId
     * @param qrcodeId
     * @return
     */
    PageBeanNew<AppStatisticsDTO> getAppStatistics(Integer currentPage, Integer numPerPage, Long bookGroupId, Long qrcodeId, Long partyId);

    /**
     * 社群码导出
     * @param paramMap
     */
    void exportGroupQrcode4Adviser(Map<String, Object> paramMap, Long adviserId);

    /**
     * 根据bookId获取社群书分类等统计
     */
    StatisticVO getBookGroupStatistics(Long bookId);

    /**
     * 根据bookId获取社群书分类和关键词等统计信息
     */
    List<ClassifyKeywordDTO> getBookGroupKeywordStatistics(Long bookId);

    /**
     * 更新是否显示书名
     */
    void updateIsShowBookName(Boolean isShowBookName, Long partyId);

    /**
     * 获取是否显示书名
     */
    Boolean getIsShowBookName(Long partyId);

    /**
     * 删除社群码
     */
    void deleteBookGroup(Long bookGroupId);

    /**
     * 根据分类id获取个人二维码信息
     */
    OwnAltQrcodeInfoDTO getOwnAltQrcodeInfoDTOByClassifyId(Long wechatUserId, Long classifyId);

    /**
     * 获取暗号状态
     */
    Integer getCipherState(String cipher);

    /**
     * 更新状态为已使用
     */
    void updateCipherStateToUsed(String cipher, String wxId);

    /**
     * 获取个人二维码方式群已使用和未使用数量
     */
    GroupUseDTO getGroupUse(List<String> altIds);

    /**
     * 获取所有的大类分类
     */
    List<LargeTempletDTO> getAllLargTemplet();

    /**
     * 根据微信id和机器人id获取分类集合
     */
    List<JoinGroupCipherDTO> getClassifyIdsByWxIdAndAltId(String wxId,String altId);

    /**
     * 获取暗号基本信息
     */
    GroupCipherDTO getJoinGroupCipher(String cipher);

    /**
     * 为信息流批量获取社群书基本信息
     */
    Map<Long, StoreFlowInfoDto> getFlowInfoByBookGroupIds(List<Long> bookGroupIds);

    /**
     * 获取指定条数社群书基本信息
     */
    Map<Long, StoreFlowInfoDto> getBookGroupInfoByChannelId(Long channelId, Integer itemNum);

    /**
     * 知识商城获取社群书信息
     */
    PageBeanNew<StoreFlowInfoDto> listBookGroup4KnowledgeMall(Long channelId, int currentPage, int numPerPage);
    /**
     * 获取用户购买或者参与过的社群书信息
     */
    PageBeanNew<GroupStoreMyPayDto> getUserBrowseGroup4KnowLedgeMall(Long channelId, Long wechatUserId, Integer currentPage, Integer numPerPage);

    /**
     * 获取社群码相关数据
     */
    BookGroupStatisticsDTO getBookGroupStatisByBookGroupId(Long bookGroupId);

    /**
     * 收益统计
     */
    PageBeanNew<ResourcesStatisticVO> getGroupIncomeStatic(GroupIncomeStaticParamVO groupIncomeStaticParamVO, Long adviserId);

    /**
     * 社群码浏览趋势图
     */
    List<GroupScanTrendVO> getGroupScanTrend(GroupScanTrendParamVO groupScanTrendParamVO, Long adviserId);

    /**
     * 社群码分类统计
     */
    PageBeanNew<GroupStatisticVO> getClassifyStatistic(Long bookGroupId, Long adviserId, Integer currentPage, Integer numPerPage);

    /**
     * 社群码分类的微信群统计
     */
    List<WxGroupStatisticVO> getQrcodeStatistic(Long bookGroupId, Long classifyId, Long adviserId);

    /**
     * 资源数据统计
     */
    TotalRescourceDataVO getTotalRescourceData(Long bookGroupId,Long adviserId, Long classifyId, Long qrcodeId, String type);

    /**
     * 资源数据导出
     */
    Map<String, String> exportRescourceIncomeData(Long bookGroupId,Long adviserId);

    /**
     * 获取资源浏览数据
     */
    Map<Long, Long> getResourcesBrowseCount(ResourceBrowseParamDto resourceBrowseParamDto);



}
