package com.pcloud.book.advertising.dao.impl;

import org.springframework.stereotype.Repository;
import com.pcloud.book.advertising.dao.AdvertisingSpaceDao;
import com.pcloud.book.advertising.dto.AdvertisingSpaceDTO;
import com.pcloud.book.advertising.entity.AdvertisingSpace;
import com.pcloud.common.core.dao.BaseDaoImpl;

/**
 * Description 广告位数据访问层接口实现类
 * @author PENG
 * @date 2019/2/28
 */
@Repository("advertisingSpaceDao")
public class AdvertisingSpaceDaoImpl extends BaseDaoImpl<AdvertisingSpace> implements AdvertisingSpaceDao {

    @Override
    public AdvertisingSpaceDTO getDTOById(Long adId) {
        return super.getSqlSession().selectOne(getStatement("getDTOById"), adId);
    }
}
