package com.pcloud.book.advertising.dto;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.pcloud.common.dto.BaseDto;

/**
 * @author PENG
 */
public class AdvertisingSpaceDTO extends BaseDto {

    private static final long serialVersionUID = -1774181367397964304L;

    /**
     * advertising_space.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_space.ad_name (广告位名称)
     */
    private String adName;

    /**
     * advertising_space.ad_position (广告位置)
     */
    private String adPosition;

    /**
     * advertising_space.ad_source (广告来源)
     */
    private String adSource;

    /**
     * advertising_space.ad_link (广告位链接)
     */
    private String adLink;

    /**
     * advertising_space.source_id (对方id)
     */
    private String sourceId;

    /**
     * advertising_space.ad_slogan (广告位文案)
     */
    private String adSlogan;

    /**
     * advertising_space.ad_pic (广告位图片)
     */
    private String adPic;

    /**
     * advertising_space.distribution_type (投放方式（0：指定书刊；1：不指定书刊）)
     */
    private Integer distributionType;

    /**
     * advertising_space.exposure_num (曝光量)
     */
    private Long exposureNum;

    /**
     * advertising_space.click_num (点击量)
     */
    private Long clickNum;

    /**
     * advertising_space.create_time (创建时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * advertising_space.update_time (修改时间)
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;

    /**
     * advertising_space.is_open (是否打开)
     */
    private Boolean isOpen;

    /**
     * 投放书刊数量
     */
    private Integer bookNum;

    /**
     * 投放书刊名称
     */
    private String bookName;

    /**
     * 书刊ID
     */
    private Long bookId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getAdPosition() {
        return adPosition;
    }

    public void setAdPosition(String adPosition) {
        this.adPosition = adPosition;
    }

    public String getAdSource() {
        return adSource;
    }

    public void setAdSource(String adSource) {
        this.adSource = adSource;
    }

    public String getAdLink() {
        return adLink;
    }

    public void setAdLink(String adLink) {
        this.adLink = adLink;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getAdSlogan() {
        return adSlogan;
    }

    public void setAdSlogan(String adSlogan) {
        this.adSlogan = adSlogan;
    }

    public String getAdPic() {
        return adPic;
    }

    public void setAdPic(String adPic) {
        this.adPic = adPic;
    }

    public Integer getDistributionType() {
        return distributionType;
    }

    public void setDistributionType(Integer distributionType) {
        this.distributionType = distributionType;
    }

    public Long getExposureNum() {
        return exposureNum;
    }

    public void setExposureNum(Long exposureNum) {
        this.exposureNum = exposureNum;
    }

    public Long getClickNum() {
        return clickNum;
    }

    public void setClickNum(Long clickNum) {
        this.clickNum = clickNum;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    public Integer getBookNum() {
        return bookNum;
    }

    public void setBookNum(Integer bookNum) {
        this.bookNum = bookNum;
    }

    public String getBookName() {
        return bookName;
    }

    public void setBookName(String bookName) {
        this.bookName = bookName;
    }

    public Long getBookId() {
        return bookId;
    }

    public void setBookId(Long bookId) {
        this.bookId = bookId;
    }

    @Override
    public String toString() {
        return "AdvertisingSpaceDTO{" +
                "id=" + id +
                ", adName='" + adName + '\'' +
                ", adPosition='" + adPosition + '\'' +
                ", adSource='" + adSource + '\'' +
                ", adLink='" + adLink + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", adSlogan='" + adSlogan + '\'' +
                ", adPic='" + adPic + '\'' +
                ", distributionType=" + distributionType +
                ", exposureNum=" + exposureNum +
                ", clickNum=" + clickNum +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isOpen=" + isOpen +
                ", bookNum=" + bookNum +
                ", bookName='" + bookName + '\'' +
                ", bookId=" + bookId +
                "} " + super.toString();
    }
}