package com.pcloud.book.advertising.entity;

import java.util.Date;
import com.pcloud.common.entity.BaseEntity;

/**
 * @author PENG
 */
public class AdvertisingSpace extends BaseEntity {

    private static final long serialVersionUID = -2436861846992974754L;

    /**
     * advertising_space.id (唯一标识)
     */
    private Long id;

    /**
     * advertising_space.ad_name (广告位名称)
     */
    private String adName;

    /**
     * advertising_space.ad_position (广告位置)
     */
    private String adPosition;

    /**
     * advertising_space.ad_source (广告来源)
     */
    private String adSource;

    /**
     * advertising_space.ad_link (广告位链接)
     */
    private String adLink;

    /**
     * advertising_space.source_id (对方id)
     */
    private String sourceId;

    /**
     * advertising_space.ad_slogan (广告位文案)
     */
    private String adSlogan;

    /**
     * advertising_space.ad_pic (广告位图片)
     */
    private String adPic;

    /**
     * advertising_space.distribution_type (投放方式（0：指定书刊；1：不指定书刊）)
     */
    private Integer distributionType;

    /**
     * advertising_space.create_time (创建时间)
     */
    private Date createTime;

    /**
     * advertising_space.update_time (修改时间)
     */
    private Date updateTime;

    /**
     * advertising_space.is_open (是否打开)
     */
    private Boolean isOpen;

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public String getAdName() {
        return adName;
    }

    public void setAdName(String adName) {
        this.adName = adName;
    }

    public String getAdPosition() {
        return adPosition;
    }

    public void setAdPosition(String adPosition) {
        this.adPosition = adPosition;
    }

    public String getAdSource() {
        return adSource;
    }

    public void setAdSource(String adSource) {
        this.adSource = adSource;
    }

    public String getAdLink() {
        return adLink;
    }

    public void setAdLink(String adLink) {
        this.adLink = adLink;
    }

    public String getSourceId() {
        return sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getAdSlogan() {
        return adSlogan;
    }

    public void setAdSlogan(String adSlogan) {
        this.adSlogan = adSlogan;
    }

    public String getAdPic() {
        return adPic;
    }

    public void setAdPic(String adPic) {
        this.adPic = adPic;
    }

    public Integer getDistributionType() {
        return distributionType;
    }

    public void setDistributionType(Integer distributionType) {
        this.distributionType = distributionType;
    }

    @Override
    public Date getCreateTime() {
        return createTime;
    }

    @Override
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @Override
    public Date getUpdateTime() {
        return updateTime;
    }

    @Override
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Boolean getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Boolean isOpen) {
        this.isOpen = isOpen;
    }

    @Override
    public String toString() {
        return "AdvertisingSpace{" +
                "id=" + id +
                ", adName='" + adName + '\'' +
                ", adPosition='" + adPosition + '\'' +
                ", adSource='" + adSource + '\'' +
                ", adLink='" + adLink + '\'' +
                ", sourceId='" + sourceId + '\'' +
                ", adSlogan='" + adSlogan + '\'' +
                ", adPic='" + adPic + '\'' +
                ", distributionType=" + distributionType +
                ", createTime=" + createTime +
                ", updateTime=" + updateTime +
                ", isOpen=" + isOpen +
                "} " + super.toString();
    }
}