package com.pcloud.book.consumer.reader;

import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.readercenter.wechat.entity.WechatUser;
import com.pcloud.readercenter.wechat.service.WechatUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author lily
 * @date 2018/12/26 16:49
 */
@Component("readerConsr")
public class ReaderConsr {
    /**
     * logger
     */
    private static final Logger LOGGER = LoggerFactory.getLogger(ReaderConsr.class);



    @Autowired
    private WechatUserService wechatUserService;

    public WechatUser getWechatUser(Long wechatUserId) throws BizException {
        if (wechatUserId == null) {
            return null;
        }
        try {
           return  ResponseHandleUtil.parseResponse(wechatUserService.getWechatUser(wechatUserId), WechatUser.class);
        } catch (Exception e) {
            LOGGER.error("获取微信用户信息失败[wechatUserService.getWechatUser]:" + e.getMessage(), e);
        }
        return null;
    }
}


