/**
 * 
 */
package com.pcloud.book.consumer.resource;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.pcloud.book.base.exception.BookBizException;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.utils.ListUtils;
import com.pcloud.common.utils.ResponseHandleUtil;
import com.pcloud.resourcecenter.product.dto.Product4BookDTO;
import com.pcloud.resourcecenter.product.dto.ProductDto;
import com.pcloud.resourcecenter.product.service.ProductService;

/**
 * @描述：商品中间件
 * @作者：songx
 * @创建时间：2016年11月17日,下午4:53:51 @版本：1.0
 */
@Component("productConsr")
public class ProductConsr {

	/**
	 * logger
	 */
	private static final Logger LOGGER = LoggerFactory.getLogger(ProductConsr.class);

	@Autowired
	private ProductService productService;

	/**
	 * 微信端，资源中心拉取商品信息
	 */
	public Map<Long, ProductDto> listProDetail4Wechat(List<Long> productIds, Long channelId) throws BizException {
		LOGGER.info("【资源中心(消)】微信端，获取商品信息,<START>.[productIds]=" + productIds.toString() + ",[channelId]=" + channelId);
		if (ListUtils.isEmpty(productIds) || channelId == null) {
			return null;
		}
		try {
			return ResponseHandleUtil.parseMapResponse(productService.listProDetail4Wechat(productIds, channelId),
					Long.class, ProductDto.class);
		} catch (BizException e) {
			LOGGER.warn("【资源中心(消)】微信端，获取商品信息失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【资源中心(消)】微信端，获取商品信息.[listProDetail4Wechat]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
		} finally {
			LOGGER.info("【资源中心(消)】微信端，获取商品信息,<END>");
		}
	}

	/**
	 * 资源中心拉取商品基本信息
	 */
	public Map<Long, ProductDto> getProBasesByIds(List<Long> productIds) throws BizException {
		LOGGER.info("【资源中心(消)】获取商品基本信息,<START>.[productIds]=" + productIds + "]");
		if (productIds == null || productIds.isEmpty()) {
			return null;
		}
		try {
			return ResponseHandleUtil.parseMapResponse(productService.getProBasesByIds(productIds), Long.class,
					ProductDto.class);
		} catch (BizException e) {
			LOGGER.warn("【资源中心(消)】获取商品基本信息失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【资源中心(消)】获取商品基本信息.[getProBasesByIds]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
		} finally {
			LOGGER.info("【资源中心(消)】获取商品基本信息,<END>");
		}
	}

	/**
	 * 资源中心拉取商品基本信息
	 */
	public Map<Long, Product4BookDTO> getProBasesWithSceneByIds(List<Long> productIds) throws BizException {
		LOGGER.info("【资源中心(消)】获取商品基本信息,<START>.[productIds]=" + productIds + "]");
		if (productIds == null || productIds.isEmpty()) {
			return null;
		}
		try {
			return ResponseHandleUtil.parseMapResponse(productService.getProInfoListWithScene(productIds), Long.class,
					Product4BookDTO.class);
		} catch (BizException e) {
			LOGGER.warn("【资源中心(消)】获取商品基本信息失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("【资源中心(消)】获取商品基本信息.[getProInfoListWithScene]:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "服务内部错误，请稍后重试");
		} finally {
			LOGGER.info("【资源中心(消)】获取商品基本信息,<END>");
		}
	}

	/**
	 * 获取问答商品信息
	 */
	public Map<Long, ProductDto> getQaProRetailBase4Group(List<Long> productIds, Long channelId, Long agentId)
			throws BizException {
		LOGGER.info("【资源中心(消)】获取问答商品信息,参数列表[productIds]:" + productIds);

		Map<Long, ProductDto> productDtoMap = new HashMap<>();
		if (productIds == null || productIds.isEmpty()) {
			LOGGER.info("【资源中心(消)】获取问答商品信息,参数为空");
			return productDtoMap;
		}
		try {
			productDtoMap = ResponseHandleUtil.parseMapResponse(
					productService.getQaProRetailBase4Group(productIds, channelId, agentId), Long.class,
					ProductDto.class);
			LOGGER.info("【资源中心(消)】获取问答商品信息结束[productService.getQaProductInfoByIds]:" + productDtoMap);
		} catch (BizException e) {
			LOGGER.warn("【资源中心(消)】获取问答商品信息失败:" + e.getMessage(), e);
			throw new BizException(e.getCode(), e.getMessage());
		} catch (Exception e) {
			LOGGER.error("获取问答商品信息失败:" + e.getMessage(), e);
			throw new BookBizException(BookBizException.INVOKE_RES_ERROR, "获取问答商品信息失败!");
		}
		return productDtoMap;
	}

}
