package com.pcloud.book.copyright.facade;

import com.pcloud.book.copyright.vo.CheckCodeParam;
import com.pcloud.book.copyright.vo.CheckIsAuthServeParam;
import com.pcloud.book.copyright.vo.CodeUseStatusVO;
import com.pcloud.common.dto.ResponseDto;
import com.pcloud.common.exceptions.BizException;
import com.pcloud.common.permission.PermissionException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * @author lily
 * @date 2018/11/29 16:58
 */
@Api(description = "授权码")
public interface BookAuthCodeFacade {

    @ApiOperation(value = "校验授权码", httpMethod = "POST")
    @RequestMapping(value = "checkCode", method = RequestMethod.POST)
    ResponseDto<CodeUseStatusVO> checkCode(@CookieValue("userInfo") String userInfo, @RequestBody CheckCodeParam checkCodeParam)
            throws PermissionException, BizException;

    @ApiOperation(value = "校验服务是否需要验证", httpMethod = "POST")
    @RequestMapping(value = "checkServe", method = RequestMethod.POST)
    ResponseDto<Boolean> checkServe(@CookieValue("userInfo") String userInfo, @RequestBody CheckIsAuthServeParam checkIsAuthServeParam)
            throws PermissionException, BizException;
}
